/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.lang;

import org.apache.commons.lang3.StringUtils;

public class Version
implements Comparable<Version> {
    private Long[] versionArray;

    public Version(String version) {
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("Argument version can not be blank.");
        }
        String[] stringVersionArrays = version.split("\\.");
        this.versionArray = new Long[stringVersionArrays.length];
        for (int i = 0; i < stringVersionArrays.length; ++i) {
            this.versionArray[i] = Long.valueOf(stringVersionArrays[i]);
        }
    }

    @Override
    public int compareTo(Version other) {
        int versionLength = this.versionArray.length;
        Long[] o2Versions = other.versionArray;
        if (versionLength != o2Versions.length) {
            throw new IllegalArgumentException("o1 and o2 version pattern not matched.");
        }
        for (int i = 0; i < versionLength; ++i) {
            if (this.versionArray[i].equals(o2Versions[i])) continue;
            return this.versionArray[i].compareTo(o2Versions[i]);
        }
        return 0;
    }
}

