/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.util;

import com.depotnearby.util.ConfigUtils;
import com.qiniu.api.auth.digest.Mac;
import com.qiniu.api.config.Config;
import com.qiniu.api.io.IoApi;
import com.qiniu.api.io.PutExtra;
import com.qiniu.api.io.PutRet;
import com.qiniu.api.net.EncodeUtils;
import com.qiniu.api.rs.Entry;
import com.qiniu.api.rs.GetPolicy;
import com.qiniu.api.rs.PutPolicy;
import com.qiniu.api.rs.RSClient;
import com.qiniu.api.rs.URLUtils;
import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QiniuUtil {
    private static final Logger logger = LoggerFactory.getLogger(QiniuUtil.class);

    public static Boolean isFileExist(String bucket, String fileName) {
        Mac mac = new Mac(Config.ACCESS_KEY, Config.SECRET_KEY);
        RSClient rsClient = new RSClient(mac);
        Entry entry = rsClient.stat(bucket, fileName);
        return entry != null && entry.ok();
    }

    public static String getDownloadUrl(String domain, String file) {
        if (StringUtils.isBlank((String)file)) {
            return "";
        }
        Mac mac = new Mac(Config.ACCESS_KEY, Config.SECRET_KEY);
        try {
            String baseUrl = URLUtils.makeBaseUrl((String)domain.replaceAll("https?\\:\\/\\/", ""), (String)file);
            GetPolicy getPolicy = new GetPolicy();
            getPolicy.expires = (int)TimeUnit.HOURS.toMillis(1L);
            return getPolicy.makeRequest(baseUrl, mac).replaceFirst("https?", "http");
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u91ca\u4e03\u725b\u6587\u4ef6URL\u5931\u8d25", e);
        }
    }

    public static void put(String bucketName, File localFile, String remoteName, Thumbnail thumbnail) {
        if (bucketName == null || localFile == null) {
            throw new NullPointerException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String uptoken = QiniuUtil.getUploadToken(bucketName, thumbnail);
        String key = remoteName == null ? localFile.getName() : remoteName;
        PutRet putRet = IoApi.putFile((String)uptoken, (String)key, (File)localFile, (PutExtra)new PutExtra());
        logger.debug("\u4e03\u725bput\u54cd\u5e94: {}", (Object)putRet.response);
    }

    public static void put(String bucketName, File localFile) {
        QiniuUtil.put(bucketName, localFile, null, null);
    }

    public static void put(String bucketName, InputStream inputStream, String remoteName, Thumbnail thumbnail) {
        QiniuUtil.put(bucketName, inputStream, -1L, remoteName, thumbnail);
    }

    public static void put(String bucketName, InputStream inputStream, long streamLength, String remoteName, Thumbnail thumbnail) {
        if (bucketName == null || inputStream == null || remoteName == null) {
            throw new NullPointerException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String uploadToken = QiniuUtil.getUploadToken(bucketName, remoteName, thumbnail);
        PutRet putRet = IoApi.Put((String)uploadToken, (String)remoteName, (InputStream)inputStream, (PutExtra)new PutExtra(), (long)(streamLength < 0L ? -1L : streamLength));
        logger.debug("Qiniu response : {}", (Object)putRet.response);
        if (!putRet.ok()) {
            throw new RuntimeException("Got an exception when upload to qiniu bucketName:" + bucketName + " ,remoteName:" + remoteName, putRet.exception);
        }
    }

    private static String getUploadToken(String bucketName, Thumbnail thumbnail) {
        PutPolicy putPolicy = new PutPolicy(bucketName);
        if (thumbnail != null) {
            if (thumbnail.name == null) {
                throw new NullPointerException("\u7f29\u7565\u56fe\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String ops = "imageView2/0/h/" + thumbnail.size;
            if (thumbnail.quality != null) {
                ops = ops + "/q/" + thumbnail.quality;
            }
            String thumbnailBucket = thumbnail.bucketName == null ? bucketName : thumbnail.bucketName;
            putPolicy.persistentOps = ops = ops + "|saveas/" + EncodeUtils.urlsafeEncode((String)(thumbnailBucket + ":" + thumbnail.name));
        }
        try {
            return putPolicy.token(null);
        }
        catch (Exception e) {
            throw new RuntimeException("\u751f\u6210\u4e03\u725btoken\u51fa\u9519", e);
        }
    }

    public static String getUploadTokenByBucketName(String bucketName) {
        return QiniuUtil.getUploadToken(bucketName, null);
    }

    private static String getUploadToken(String bucketName, String key, Thumbnail thumbnail) {
        String scope = bucketName + ":" + key;
        return QiniuUtil.getUploadToken(scope, thumbnail);
    }

    static {
        try {
            Properties config = ConfigUtils.loadFromFileOrZooKeeper("/gridy/config/qiniu.properties", "qiniu.properties");
            Config.ACCESS_KEY = config.getProperty("qiniu.ak");
            Config.SECRET_KEY = config.getProperty("qiniu.sk");
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u8f7d\u4e03\u725b\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", e);
        }
    }

    public static class Thumbnail {
        public String bucketName;
        public String name;
        public Integer quality;
        public int size = 280;
    }
}

