/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.util;

import com.google.common.collect.Lists;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class SignUtils {
    public static String sign(String signKey, Map<String, ?> data, String noiseKey, String noiseValue) {
        TreeSet<String> signParamNames = new TreeSet<String>(data.keySet());
        ArrayList keyValuePair = Lists.newArrayList();
        for (String signParamName : signParamNames) {
            String[] valueArray;
            Object value = data.get(signParamName);
            if (value == null || Objects.equals(signKey, signParamName)) continue;
            String signParamValue = Objects.toString(value);
            if (value instanceof String[] && (valueArray = (String[])value).length > 0) {
                signParamValue = valueArray[0];
            }
            if (!StringUtils.isNotBlank((CharSequence)signParamValue)) continue;
            keyValuePair.add(signParamName + "=" + signParamValue);
        }
        keyValuePair.add(noiseKey + "=" + noiseValue);
        String finalParams = StringUtils.join((Iterable)keyValuePair, (String)"&");
        return SignUtils.encodedByMD5(finalParams);
    }

    private static String encodedByMD5(String password) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(password.getBytes());
            return SignUtils.byte2string(md.digest());
        }
        catch (Exception e) {
            return password;
        }
    }

    private static String byte2string(byte[] b) {
        StringBuilder hs = new StringBuilder(100);
        for (byte aB : b) {
            hs.append(SignUtils.byte2fex(aB));
        }
        return hs.toString();
    }

    private static String byte2fex(byte ib) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] ob = new char[]{Digit[ib >>> 4 & 0xF], Digit[ib & 0xF]};
        return new String(ob);
    }
}

