/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.util;

import com.depotnearby.util.ZooClient;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkProperties {
    private static final Logger LOG = LoggerFactory.getLogger(ZkProperties.class);
    private Properties config;
    private byte[] configBytes;

    public ZkProperties(String path) {
        this(path, false);
    }

    public ZkProperties(final String path, boolean watch) {
        try {
            byte[] data;
            final CuratorFramework curator = ZooClient.getClient();
            if (curator.checkExists().forPath(path) == null) {
                LOG.debug("zk \u6587\u4ef6:{} \u4e0d\u5b58\u5728, \u521b\u5efazk\u6587\u4ef6", (Object)path);
                ((ACLBackgroundPathAndBytesable)curator.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(path);
            }
            if (watch) {
                Watcher watcher = new Watcher(){

                    public void process(WatchedEvent event) {
                        if (event.getType() == Watcher.Event.EventType.NodeCreated || event.getType() == Watcher.Event.EventType.NodeDataChanged) {
                            LOG.debug("NodeDataChanged");
                            try {
                                byte[] data = (byte[])((BackgroundPathable)curator.getData().usingWatcher((Watcher)this)).forPath(path);
                                ZkProperties.this.reloadProperties(data);
                            }
                            catch (Exception e) {
                                LOG.error("error", (Throwable)e);
                            }
                        }
                    }
                };
                data = (byte[])((BackgroundPathable)curator.getData().usingWatcher(watcher)).forPath(path);
            } else {
                data = (byte[])curator.getData().forPath(path);
            }
            this.reloadProperties(data);
            LOG.debug("\u52a0\u8f7dzk properties : {} \u6210\u529f", (Object)path);
        }
        catch (Exception e) {
            throw new RuntimeException("\u521d\u59cb\u5316\u5931\u8d25", e);
        }
    }

    private void reloadProperties(byte[] data) throws IOException {
        Properties c = ZkProperties.createEmptyConfig();
        if (data != null) {
            c.load(new ByteArrayInputStream(data));
        }
        this.config = c;
        this.configBytes = data;
    }

    public String getProperty(String key) {
        return this.config == null ? null : this.config.getProperty(key);
    }

    public Long getLong(String key) {
        String p = this.getProperty(key);
        return StringUtils.isBlank((CharSequence)p) ? null : Long.valueOf(p);
    }

    public Properties getProperties() {
        return this.config;
    }

    public byte[] getPropertiesBytes() {
        return this.configBytes;
    }

    private static Properties createEmptyConfig() {
        Properties c = new Properties();
        return c;
    }
}

