/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.util;

import com.depotnearby.util.ConfigUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooClient {
    private static final Logger LOG = LoggerFactory.getLogger(ZooClient.class);
    private static CuratorFramework client;

    public static synchronized CuratorFramework getClient() {
        if (client == null) {
            String zookeeperUrl = ZooClient.getZookeeperUrl().replace("zookeeper://", "").replace("?backup=", ",").replaceAll("&", ",");
            LOG.debug("zookeeperUrl: {}", (Object)zookeeperUrl);
            try {
                client = CuratorFrameworkFactory.builder().connectString(zookeeperUrl).retryPolicy((RetryPolicy)new RetryNTimes(Integer.MAX_VALUE, 1000)).connectionTimeoutMs(5000).build();
                client.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return client;
    }

    private static String getZookeeperUrl() {
        String url = ConfigUtils.getZookeeperUrl();
        if (url == null) {
            try {
                url = ConfigUtils.getString("config.properties", "zookeeper.url");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return url;
    }

    public static void close() {
        if (client != null) {
            client.close();
        }
    }
}

