/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.util;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;

public class UtilDateTime {
    public static final String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    public static final String[] days = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
    public static final String[][] timevals = new String[][]{{"1000", "millisecond"}, {"60", "second"}, {"60", "minute"}, {"24", "hour"}, {"168", "week"}};
    public static final DecimalFormat df = new DecimalFormat("0.00;-0.00");
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String TIME_FORMAT = "HH:mm:ss";
    protected static List<TimeZone> availableTimeZoneList = null;

    public static double getInterval(java.util.Date from, java.util.Date thru) {
        return thru != null ? (double)(thru.getTime() - from.getTime()) : 0.0;
    }

    public static int getIntervalInDays(Timestamp from, Timestamp thru) {
        return thru != null ? (int)((thru.getTime() - from.getTime()) / 86400000L) : 0;
    }

    public static Timestamp addDaysToTimestamp(Timestamp start, int days) {
        return new Timestamp(start.getTime() + 86400000L * (long)days);
    }

    public static Timestamp addDaysToTimestamp(Timestamp start, Double days) {
        return new Timestamp(start.getTime() + (long)((int)(8.64E7 * days)));
    }

    public static double getInterval(Timestamp from, Timestamp thru) {
        return thru != null ? (double)(thru.getTime() - from.getTime() + (long)((thru.getNanos() - from.getNanos()) / 1000000)) : 0.0;
    }

    public static String formatInterval(java.util.Date from, java.util.Date thru, int count, Locale locale) {
        return UtilDateTime.formatInterval(UtilDateTime.getInterval(from, thru), count, locale);
    }

    public static String formatInterval(java.util.Date from, java.util.Date thru, Locale locale) {
        return UtilDateTime.formatInterval(from, thru, 2, locale);
    }

    public static String formatInterval(Timestamp from, Timestamp thru, int count, Locale locale) {
        return UtilDateTime.formatInterval(UtilDateTime.getInterval(from, thru), count, locale);
    }

    public static String formatInterval(Timestamp from, Timestamp thru, Locale locale) {
        return UtilDateTime.formatInterval(from, thru, 2, locale);
    }

    public static String formatInterval(long interval, int count, Locale locale) {
        return UtilDateTime.formatInterval((double)interval, count, locale);
    }

    public static String formatInterval(long interval, Locale locale) {
        return UtilDateTime.formatInterval(interval, 2, locale);
    }

    public static String formatInterval(double interval, Locale locale) {
        return UtilDateTime.formatInterval(interval, 2, locale);
    }

    public static String formatInterval(double interval, int count, Locale locale) {
        ArrayList<Double> parts = new ArrayList<Double>(timevals.length);
        for (String[] timeval : timevals) {
            int value = Integer.valueOf(timeval[0]);
            double remainder = interval % (double)value;
            interval /= (double)value;
            parts.add(remainder);
        }
        Map uiDateTimeMap = null;
        StringBuilder sb = new StringBuilder();
        for (int i = parts.size() - 1; i >= 0 && count > 0; --i) {
            Double D = (Double)parts.get(i);
            double d = D;
            if (d < 1.0) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(--count == 0 ? df.format(d) : Integer.toString(D.intValue()));
            sb.append(' ');
            Object label = D.intValue() == 1 ? uiDateTimeMap.get(timevals[i][1] + ".singular") : uiDateTimeMap.get(timevals[i][1] + ".plural");
            sb.append(label);
        }
        return sb.toString();
    }

    public static Timestamp nowTimestamp() {
        return UtilDateTime.getTimestamp(System.currentTimeMillis());
    }

    public static Timestamp getTimestamp(long time) {
        return new Timestamp(time);
    }

    public static Timestamp getTimestamp(String milliSecs) throws NumberFormatException {
        return new Timestamp(Long.parseLong(milliSecs));
    }

    public static String nowAsString() {
        return Long.toString(System.currentTimeMillis());
    }

    public static String nowDateString() {
        return UtilDateTime.nowDateString("yyyyMMddHHmmss");
    }

    public static String nowDateString(String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(new java.util.Date());
    }

    public static java.util.Date nowDate() {
        return new java.util.Date();
    }

    public static Timestamp getDayStart(Timestamp stamp) {
        return UtilDateTime.getDayStart(stamp, 0);
    }

    public static Timestamp getDayStart(Timestamp stamp, int daysLater) {
        return UtilDateTime.getDayStart(stamp, daysLater, TimeZone.getDefault(), Locale.getDefault());
    }

    public static Timestamp getNextDayStart(Timestamp stamp) {
        return UtilDateTime.getDayStart(stamp, 1);
    }

    public static Timestamp getDayEnd(Timestamp stamp) {
        return UtilDateTime.getDayEnd(stamp, 0L);
    }

    public static Timestamp getDayEnd(Timestamp stamp, Long daysLater) {
        return UtilDateTime.getDayEnd(stamp, daysLater, TimeZone.getDefault(), Locale.getDefault());
    }

    public static Timestamp getYearStart(Timestamp stamp) {
        return UtilDateTime.getYearStart(stamp, 0, 0, 0);
    }

    public static Timestamp getYearStart(Timestamp stamp, int daysLater) {
        return UtilDateTime.getYearStart(stamp, daysLater, 0, 0);
    }

    public static Timestamp getYearStart(Timestamp stamp, int daysLater, int yearsLater) {
        return UtilDateTime.getYearStart(stamp, daysLater, 0, yearsLater);
    }

    public static Timestamp getYearStart(Timestamp stamp, int daysLater, int monthsLater, int yearsLater) {
        return UtilDateTime.getYearStart(stamp, daysLater, monthsLater, yearsLater, TimeZone.getDefault(), Locale.getDefault());
    }

    public static Timestamp getYearStart(Timestamp stamp, Number daysLater, Number monthsLater, Number yearsLater) {
        return UtilDateTime.getYearStart(stamp, daysLater == null ? 0 : daysLater.intValue(), monthsLater == null ? 0 : monthsLater.intValue(), yearsLater == null ? 0 : yearsLater.intValue());
    }

    public static Timestamp getMonthStart(Timestamp stamp) {
        return UtilDateTime.getMonthStart(stamp, 0, 0);
    }

    public static Timestamp getMonthStart(Timestamp stamp, int daysLater) {
        return UtilDateTime.getMonthStart(stamp, daysLater, 0);
    }

    public static Timestamp getMonthStart(Timestamp stamp, int daysLater, int monthsLater) {
        return UtilDateTime.getMonthStart(stamp, daysLater, monthsLater, TimeZone.getDefault(), Locale.getDefault());
    }

    public static Timestamp getWeekStart(Timestamp stamp) {
        return UtilDateTime.getWeekStart(stamp, 0, 0);
    }

    public static Timestamp getWeekStart(Timestamp stamp, int daysLater) {
        return UtilDateTime.getWeekStart(stamp, daysLater, 0);
    }

    public static Timestamp getWeekStart(Timestamp stamp, int daysLater, int weeksLater) {
        return UtilDateTime.getWeekStart(stamp, daysLater, weeksLater, TimeZone.getDefault(), Locale.getDefault());
    }

    public static Timestamp getWeekEnd(Timestamp stamp) {
        return UtilDateTime.getWeekEnd(stamp, TimeZone.getDefault(), Locale.getDefault());
    }

    public static com.ibm.icu.util.Calendar toCalendar(Timestamp stamp) {
        com.ibm.icu.util.Calendar cal = com.ibm.icu.util.Calendar.getInstance();
        if (stamp != null) {
            cal.setTimeInMillis(stamp.getTime());
        }
        return cal;
    }

    public static Date toSqlDate(String date) {
        java.util.Date newDate = UtilDateTime.toDate(date, "00:00:00");
        if (newDate != null) {
            return new Date(newDate.getTime());
        }
        return null;
    }

    public static Date toSqlDate(String monthStr, String dayStr, String yearStr) {
        java.util.Date newDate = UtilDateTime.toDate(monthStr, dayStr, yearStr, "0", "0", "0");
        if (newDate != null) {
            return new Date(newDate.getTime());
        }
        return null;
    }

    public static Date toSqlDate(int month, int day, int year) {
        java.util.Date newDate = UtilDateTime.toDate(month, day, year, 0, 0, 0);
        if (newDate != null) {
            return new Date(newDate.getTime());
        }
        return null;
    }

    public static Time toSqlTime(String time) {
        java.util.Date newDate = UtilDateTime.toDate("1/1/1970", time);
        if (newDate != null) {
            return new Time(newDate.getTime());
        }
        return null;
    }

    public static Time toSqlTime(String hourStr, String minuteStr, String secondStr) {
        java.util.Date newDate = UtilDateTime.toDate("0", "0", "0", hourStr, minuteStr, secondStr);
        if (newDate != null) {
            return new Time(newDate.getTime());
        }
        return null;
    }

    public static Time toSqlTime(int hour, int minute, int second) {
        java.util.Date newDate = UtilDateTime.toDate(0, 0, 0, hour, minute, second);
        if (newDate != null) {
            return new Time(newDate.getTime());
        }
        return null;
    }

    public static Timestamp toTimestamp(String dateTime) {
        java.util.Date newDate = UtilDateTime.toDate(dateTime);
        if (newDate != null) {
            return new Timestamp(newDate.getTime());
        }
        return null;
    }

    public static Timestamp toTimestamp(String date, String time) {
        java.util.Date newDate = UtilDateTime.toDate(date, time);
        if (newDate != null) {
            return new Timestamp(newDate.getTime());
        }
        return null;
    }

    public static Timestamp toTimestamp(String monthStr, String dayStr, String yearStr, String hourStr, String minuteStr, String secondStr) {
        java.util.Date newDate = UtilDateTime.toDate(monthStr, dayStr, yearStr, hourStr, minuteStr, secondStr);
        if (newDate != null) {
            return new Timestamp(newDate.getTime());
        }
        return null;
    }

    public static Timestamp toTimestamp(int month, int day, int year, int hour, int minute, int second) {
        java.util.Date newDate = UtilDateTime.toDate(month, day, year, hour, minute, second);
        if (newDate != null) {
            return new Timestamp(newDate.getTime());
        }
        return null;
    }

    public static Timestamp toTimestamp(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public static java.util.Date toDate(String dateTime) {
        if (dateTime == null) {
            return null;
        }
        String date = dateTime.substring(0, dateTime.indexOf(" "));
        String time = dateTime.substring(dateTime.indexOf(" ") + 1);
        return UtilDateTime.toDate(date, time);
    }

    public static java.util.Date toDate(String date, String time) {
        String second;
        String minute;
        if (date == null || time == null) {
            return null;
        }
        int dateSlash1 = date.indexOf("/");
        int dateSlash2 = date.lastIndexOf("/");
        if (dateSlash1 <= 0 || dateSlash1 == dateSlash2) {
            return null;
        }
        int timeColon1 = time.indexOf(":");
        int timeColon2 = time.lastIndexOf(":");
        if (timeColon1 <= 0) {
            return null;
        }
        String month = date.substring(0, dateSlash1);
        String day = date.substring(dateSlash1 + 1, dateSlash2);
        String year = date.substring(dateSlash2 + 1);
        String hour = time.substring(0, timeColon1);
        if (timeColon1 == timeColon2) {
            minute = time.substring(timeColon1 + 1);
            second = "0";
        } else {
            minute = time.substring(timeColon1 + 1, timeColon2);
            second = time.substring(timeColon2 + 1);
        }
        return UtilDateTime.toDate(month, day, year, hour, minute, second);
    }

    public static java.util.Date toDate(String monthStr, String dayStr, String yearStr, String hourStr, String minuteStr, String secondStr) {
        int second;
        int minute;
        int hour;
        int year;
        int day;
        int month;
        try {
            month = Integer.parseInt(monthStr);
            day = Integer.parseInt(dayStr);
            year = Integer.parseInt(yearStr);
            hour = Integer.parseInt(hourStr);
            minute = Integer.parseInt(minuteStr);
            second = Integer.parseInt(secondStr);
        }
        catch (Exception e) {
            return null;
        }
        return UtilDateTime.toDate(month, day, year, hour, minute, second);
    }

    public static java.util.Date toDate(int month, int day, int year, int hour, int minute, int second) {
        com.ibm.icu.util.Calendar calendar = com.ibm.icu.util.Calendar.getInstance();
        try {
            calendar.set(year, month - 1, day, hour, minute, second);
            calendar.set(14, 0);
        }
        catch (Exception e) {
            return null;
        }
        return new java.util.Date(calendar.getTime().getTime());
    }

    public static String toDateString(java.util.Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = null;
        dateFormat = format != null ? new SimpleDateFormat(format) : new SimpleDateFormat();
        com.ibm.icu.util.Calendar calendar = com.ibm.icu.util.Calendar.getInstance();
        calendar.setTime(date);
        return dateFormat.format(date);
    }

    public static String toDateString(java.util.Date date) {
        return UtilDateTime.toDateString(date, "MM/dd/yyyy");
    }

    public static String toTimeString(java.util.Date date) {
        if (date == null) {
            return "";
        }
        com.ibm.icu.util.Calendar calendar = com.ibm.icu.util.Calendar.getInstance();
        calendar.setTime(date);
        return UtilDateTime.toTimeString(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public static String toTimeString(int hour, int minute, int second) {
        String hourStr = hour < 10 ? "0" + hour : "" + hour;
        String minuteStr = minute < 10 ? "0" + minute : "" + minute;
        String secondStr = second < 10 ? "0" + second : "" + second;
        if (second == 0) {
            return hourStr + ":" + minuteStr;
        }
        return hourStr + ":" + minuteStr + ":" + secondStr;
    }

    public static String toDateTimeString(java.util.Date date) {
        if (date == null) {
            return "";
        }
        String dateString = UtilDateTime.toDateString(date);
        String timeString = UtilDateTime.toTimeString(date);
        if (dateString != null && timeString != null) {
            return dateString + " " + timeString;
        }
        return "";
    }

    public static String toGmtTimestampString(Timestamp timestamp) {
        DateFormat df = DateFormat.getDateTimeInstance();
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(timestamp);
    }

    public static Timestamp monthBegin() {
        com.ibm.icu.util.Calendar mth = com.ibm.icu.util.Calendar.getInstance();
        mth.set(5, 1);
        mth.set(11, 0);
        mth.set(12, 0);
        mth.set(13, 0);
        mth.set(14, 0);
        mth.set(9, 0);
        return new Timestamp(mth.getTime().getTime());
    }

    public static int weekNumber(Timestamp input) {
        return UtilDateTime.weekNumber(input, TimeZone.getDefault(), Locale.getDefault());
    }

    public static int dayNumber(Timestamp stamp) {
        com.ibm.icu.util.Calendar tempCal = UtilDateTime.toCalendar(stamp, TimeZone.getDefault(), Locale.getDefault());
        return tempCal.get(7);
    }

    public static int weekNumber(Timestamp input, int startOfWeek) {
        com.ibm.icu.util.Calendar calendar = com.ibm.icu.util.Calendar.getInstance();
        calendar.setFirstDayOfWeek(startOfWeek);
        if (startOfWeek == 2) {
            calendar.setMinimalDaysInFirstWeek(4);
        } else if (startOfWeek == 1) {
            calendar.setMinimalDaysInFirstWeek(3);
        }
        calendar.setTime(new java.util.Date(input.getTime()));
        return calendar.get(3);
    }

    public static com.ibm.icu.util.Calendar getCalendarInstance(TimeZone timeZone, Locale locale) {
        return com.ibm.icu.util.Calendar.getInstance((com.ibm.icu.util.TimeZone)com.ibm.icu.util.TimeZone.getTimeZone((String)timeZone.getID()), (Locale)locale);
    }

    public static com.ibm.icu.util.Calendar toCalendar(java.util.Date date, TimeZone timeZone, Locale locale) {
        com.ibm.icu.util.Calendar cal = UtilDateTime.getCalendarInstance(timeZone, locale);
        if (date != null) {
            cal.setTime(date);
        }
        return cal;
    }

    public static Timestamp adjustTimestamp(Timestamp stamp, int adjType, int adjQuantity, TimeZone timeZone, Locale locale) {
        com.ibm.icu.util.Calendar tempCal = UtilDateTime.toCalendar(stamp, timeZone, locale);
        tempCal.add(adjType, adjQuantity);
        return new Timestamp(tempCal.getTimeInMillis());
    }

    public static Timestamp adjustTimestamp(Timestamp stamp, Integer adjType, Integer adjQuantity) {
        com.ibm.icu.util.Calendar tempCal = UtilDateTime.toCalendar(stamp);
        tempCal.add(adjType.intValue(), adjQuantity.intValue());
        return new Timestamp(tempCal.getTimeInMillis());
    }

    public static Timestamp getDayStart(Timestamp stamp, TimeZone timeZone, Locale locale) {
        return UtilDateTime.getDayStart(stamp, 0, timeZone, locale);
    }

    public static Timestamp getDayStart(Timestamp stamp, int daysLater, TimeZone timeZone, Locale locale) {
        com.ibm.icu.util.Calendar tempCal = UtilDateTime.toCalendar(stamp, timeZone, locale);
        tempCal.set(tempCal.get(1), tempCal.get(2), tempCal.get(5), 0, 0, 0);
        tempCal.add(5, daysLater);
        Timestamp retStamp = new Timestamp(tempCal.getTimeInMillis());
        retStamp.setNanos(0);
        return retStamp;
    }

    public static Timestamp getDayEnd(Timestamp stamp, TimeZone timeZone, Locale locale) {
        return UtilDateTime.getDayEnd(stamp, 0L, timeZone, locale);
    }

    public static Timestamp getDayEnd(Timestamp stamp, Long daysLater, TimeZone timeZone, Locale locale) {
        com.ibm.icu.util.Calendar tempCal = UtilDateTime.toCalendar(stamp, timeZone, locale);
        tempCal.set(tempCal.get(1), tempCal.get(2), tempCal.get(5), 23, 59, 59);
        tempCal.add(5, daysLater.intValue());
        Timestamp retStamp = new Timestamp(tempCal.getTimeInMillis());
        retStamp.setNanos(0);
        return retStamp;
    }

    public static Timestamp getWeekStart(Timestamp stamp, TimeZone timeZone, Locale locale) {
        return UtilDateTime.getWeekStart(stamp, 0, 0, timeZone, locale);
    }

    public static Timestamp getWeekStart(Timestamp stamp, int daysLater, TimeZone timeZone, Locale locale) {
        return UtilDateTime.getWeekStart(stamp, daysLater, 0, timeZone, locale);
    }

    public static Timestamp getWeekStart(Timestamp stamp, int daysLater, int weeksLater, TimeZone timeZone, Locale locale) {
        com.ibm.icu.util.Calendar tempCal = UtilDateTime.toCalendar(stamp, timeZone, locale);
        tempCal.set(tempCal.get(1), tempCal.get(2), tempCal.get(5), 0, 0, 0);
        tempCal.add(5, daysLater);
        tempCal.set(7, tempCal.getFirstDayOfWeek());
        tempCal.add(4, weeksLater);
        Timestamp retStamp = new Timestamp(tempCal.getTimeInMillis());
        retStamp.setNanos(0);
        return retStamp;
    }

    public static Timestamp getWeekEnd(Timestamp stamp, TimeZone timeZone, Locale locale) {
        Timestamp weekStart = UtilDateTime.getWeekStart(stamp, timeZone, locale);
        com.ibm.icu.util.Calendar tempCal = UtilDateTime.toCalendar(weekStart, timeZone, locale);
        tempCal.add(5, 6);
        return UtilDateTime.getDayEnd(new Timestamp(tempCal.getTimeInMillis()), timeZone, locale);
    }

    public static Timestamp getMonthStart(Timestamp stamp, TimeZone timeZone, Locale locale) {
        return UtilDateTime.getMonthStart(stamp, 0, 0, timeZone, locale);
    }

    public static Timestamp getMonthStart(Timestamp stamp, int daysLater, TimeZone timeZone, Locale locale) {
        return UtilDateTime.getMonthStart(stamp, daysLater, 0, timeZone, locale);
    }

    public static Timestamp getMonthStart(Timestamp stamp, int daysLater, int monthsLater, TimeZone timeZone, Locale locale) {
        com.ibm.icu.util.Calendar tempCal = UtilDateTime.toCalendar(stamp, timeZone, locale);
        tempCal.set(tempCal.get(1), tempCal.get(2), 1, 0, 0, 0);
        tempCal.add(2, monthsLater);
        tempCal.add(5, daysLater);
        Timestamp retStamp = new Timestamp(tempCal.getTimeInMillis());
        retStamp.setNanos(0);
        return retStamp;
    }

    public static Timestamp getMonthEnd(Timestamp stamp, TimeZone timeZone, Locale locale) {
        com.ibm.icu.util.Calendar tempCal = UtilDateTime.toCalendar(stamp, timeZone, locale);
        tempCal.set(tempCal.get(1), tempCal.get(2), tempCal.getActualMaximum(5), 0, 0, 0);
        return UtilDateTime.getDayEnd(new Timestamp(tempCal.getTimeInMillis()), timeZone, locale);
    }

    public static Timestamp getYearStart(Timestamp stamp, TimeZone timeZone, Locale locale) {
        return UtilDateTime.getYearStart(stamp, 0, 0, 0, timeZone, locale);
    }

    public static Timestamp getYearStart(Timestamp stamp, int daysLater, TimeZone timeZone, Locale locale) {
        return UtilDateTime.getYearStart(stamp, daysLater, 0, 0, timeZone, locale);
    }

    public static Timestamp getYearStart(Timestamp stamp, int daysLater, int yearsLater, TimeZone timeZone, Locale locale) {
        return UtilDateTime.getYearStart(stamp, daysLater, 0, yearsLater, timeZone, locale);
    }

    public static Timestamp getYearStart(Timestamp stamp, Number daysLater, Number monthsLater, Number yearsLater, TimeZone timeZone, Locale locale) {
        return UtilDateTime.getYearStart(stamp, daysLater == null ? 0 : daysLater.intValue(), monthsLater == null ? 0 : monthsLater.intValue(), yearsLater == null ? 0 : yearsLater.intValue(), timeZone, locale);
    }

    public static Timestamp getYearStart(Timestamp stamp, int daysLater, int monthsLater, int yearsLater, TimeZone timeZone, Locale locale) {
        com.ibm.icu.util.Calendar tempCal = UtilDateTime.toCalendar(stamp, timeZone, locale);
        tempCal.set(tempCal.get(1), 0, 1, 0, 0, 0);
        tempCal.add(1, yearsLater);
        tempCal.add(2, monthsLater);
        tempCal.add(5, daysLater);
        Timestamp retStamp = new Timestamp(tempCal.getTimeInMillis());
        retStamp.setNanos(0);
        return retStamp;
    }

    public static Timestamp getYearEnd(Timestamp stamp, TimeZone timeZone, Locale locale) {
        com.ibm.icu.util.Calendar tempCal = UtilDateTime.toCalendar(stamp, timeZone, locale);
        tempCal.set(tempCal.get(1), tempCal.getActualMaximum(2) + 1, 0, 0, 0, 0);
        return UtilDateTime.getMonthEnd(new Timestamp(tempCal.getTimeInMillis()), timeZone, locale);
    }

    public static int weekNumber(Timestamp stamp, TimeZone timeZone, Locale locale) {
        com.ibm.icu.util.Calendar tempCal = UtilDateTime.toCalendar(stamp, timeZone, locale);
        return tempCal.get(3);
    }

    public static List<String> getDayNames(Locale locale) {
        com.ibm.icu.util.Calendar tempCal = com.ibm.icu.util.Calendar.getInstance((Locale)locale);
        tempCal.set(7, tempCal.getFirstDayOfWeek());
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEEE", locale);
        ArrayList<String> resultList = new ArrayList<String>();
        for (int i = 0; i < 7; ++i) {
            resultList.add(dateFormat.format(tempCal.getTime()));
            tempCal.roll(7, 1);
        }
        return resultList;
    }

    public static List<String> getMonthNames(Locale locale) {
        com.ibm.icu.util.Calendar tempCal = com.ibm.icu.util.Calendar.getInstance((Locale)locale);
        tempCal.set(2, 0);
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM", locale);
        ArrayList<String> resultList = new ArrayList<String>();
        for (int i = 0; i <= tempCal.getActualMaximum(2); ++i) {
            resultList.add(dateFormat.format(tempCal.getTime()));
            tempCal.roll(2, 1);
        }
        return resultList;
    }

    public static DateFormat toDateFormat(String dateFormat, TimeZone tz, Locale locale) {
        DateFormat df = null;
        df = StringUtils.isEmpty((String)dateFormat) ? DateFormat.getDateInstance(3, locale) : new SimpleDateFormat(dateFormat, locale == null ? Locale.getDefault() : locale);
        df.setTimeZone(tz);
        return df;
    }

    public static DateFormat toDateTimeFormat(String dateTimeFormat, TimeZone tz, Locale locale) {
        DateFormat df = null;
        df = StringUtils.isEmpty((String)dateTimeFormat) ? DateFormat.getDateTimeInstance(3, 2, locale) : new SimpleDateFormat(dateTimeFormat, locale == null ? Locale.getDefault() : locale);
        df.setTimeZone(tz);
        return df;
    }

    public static DateFormat toTimeFormat(String timeFormat, TimeZone tz, Locale locale) {
        DateFormat df = null;
        df = StringUtils.isEmpty((String)timeFormat) ? DateFormat.getTimeInstance(2, locale) : new SimpleDateFormat(timeFormat, locale == null ? Locale.getDefault() : locale);
        df.setTimeZone(tz);
        return df;
    }

    public static Timestamp stringToTimeStamp(String dateTimeString, TimeZone tz, Locale locale) throws ParseException {
        return UtilDateTime.stringToTimeStamp(dateTimeString, null, tz, locale);
    }

    public static Timestamp stringToTimeStamp(String dateTimeString, String dateTimeFormat, TimeZone tz, Locale locale) throws ParseException {
        DateFormat dateFormat = UtilDateTime.toDateTimeFormat(dateTimeFormat, tz, locale);
        java.util.Date parsedDate = dateFormat.parse(dateTimeString);
        return new Timestamp(parsedDate.getTime());
    }

    public static String timeStampToString(Timestamp stamp, TimeZone tz, Locale locale) {
        return UtilDateTime.timeStampToString(stamp, null, tz, locale);
    }

    public static String timeStampToString(Timestamp stamp, String dateTimeFormat, TimeZone tz, Locale locale) {
        DateFormat dateFormat = UtilDateTime.toDateTimeFormat(dateTimeFormat, tz, locale);
        return dateFormat.format(stamp);
    }

    public static List<TimeZone> availableTimeZones() {
        return availableTimeZoneList;
    }

    public static TimeZone toTimeZone(String tzId) {
        if (StringUtils.isEmpty((String)tzId)) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(tzId);
    }

    public static TimeZone toTimeZone(int gmtOffset) {
        if (gmtOffset > 12 || gmtOffset < -14) {
            throw new IllegalArgumentException("Invalid GMT offset");
        }
        String tzId = gmtOffset > 0 ? "Etc/GMT+" : "Etc/GMT";
        return TimeZone.getTimeZone(tzId + gmtOffset);
    }

    public static int getSecond(Timestamp stamp, TimeZone timeZone, Locale locale) {
        com.ibm.icu.util.Calendar cal = UtilDateTime.toCalendar(stamp, timeZone, locale);
        return cal.get(13);
    }

    public static int getMinute(Timestamp stamp, TimeZone timeZone, Locale locale) {
        com.ibm.icu.util.Calendar cal = UtilDateTime.toCalendar(stamp, timeZone, locale);
        return cal.get(12);
    }

    public static int getHour(Timestamp stamp, TimeZone timeZone, Locale locale) {
        com.ibm.icu.util.Calendar cal = UtilDateTime.toCalendar(stamp, timeZone, locale);
        return cal.get(11);
    }

    public static int getDayOfWeek(Timestamp stamp, TimeZone timeZone, Locale locale) {
        com.ibm.icu.util.Calendar cal = UtilDateTime.toCalendar(stamp, timeZone, locale);
        return cal.get(7);
    }

    public static int getDayOfMonth(Timestamp stamp, TimeZone timeZone, Locale locale) {
        com.ibm.icu.util.Calendar cal = UtilDateTime.toCalendar(stamp, timeZone, locale);
        return cal.get(5);
    }

    public static int getDayOfYear(Timestamp stamp, TimeZone timeZone, Locale locale) {
        com.ibm.icu.util.Calendar cal = UtilDateTime.toCalendar(stamp, timeZone, locale);
        return cal.get(6);
    }

    public static int getWeek(Timestamp stamp, TimeZone timeZone, Locale locale) {
        com.ibm.icu.util.Calendar cal = UtilDateTime.toCalendar(stamp, timeZone, locale);
        return cal.get(3);
    }

    public static int getMonth(Timestamp stamp, TimeZone timeZone, Locale locale) {
        com.ibm.icu.util.Calendar cal = UtilDateTime.toCalendar(stamp, timeZone, locale);
        return cal.get(2);
    }

    public static int getYear(Timestamp stamp, TimeZone timeZone, Locale locale) {
        com.ibm.icu.util.Calendar cal = UtilDateTime.toCalendar(stamp, timeZone, locale);
        return cal.get(1);
    }

    public static java.util.Date getEarliestDate() {
        com.ibm.icu.util.Calendar cal = UtilDateTime.getCalendarInstance(TimeZone.getTimeZone("GMT"), Locale.getDefault());
        cal.set(1, cal.getActualMinimum(1));
        cal.set(2, cal.getActualMinimum(2));
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static java.util.Date getLatestDate() {
        com.ibm.icu.util.Calendar cal = UtilDateTime.getCalendarInstance(TimeZone.getTimeZone("GMT"), Locale.getDefault());
        cal.set(1, cal.getActualMaximum(1));
        cal.set(2, cal.getActualMaximum(2));
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static java.util.Date getTheLastTime(java.util.Date endTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endTime);
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }
}

