/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.util;

import com.depotnearby.util.ZkProperties;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    private static final Map<String, PropertiesConfiguration> propertyConfigMap = new HashMap<String, PropertiesConfiguration>();
    private static final Logger logger = LoggerFactory.getLogger(ConfigUtils.class);

    private ConfigUtils() {
    }

    private static PropertiesConfiguration getConfig(String propertyFileName) {
        PropertiesConfiguration config = propertyConfigMap.get(propertyFileName);
        if (config == null) {
            try {
                config = new PropertiesConfiguration(propertyFileName);
                logger.debug("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u6210\u529f");
            }
            catch (ConfigurationException e) {
                throw new RuntimeException("\u52a0\u8f7d\u914d\u7f6e" + propertyFileName + "\u51fa\u9519", e);
            }
            propertyConfigMap.put(propertyFileName, config);
        }
        return config;
    }

    public static String getString(String propertyFileName, String propertyName) {
        return ConfigUtils.getConfig(propertyFileName).getString(propertyName);
    }

    public static boolean isConfiguredByZoo() {
        return ConfigUtils.getZookeeperUrl() != null;
    }

    public static String getZookeeperUrl() {
        return System.getProperty("zookeeper.url");
    }

    public static Properties loadFromFileOrZooKeeper(String zooPath, String classPath) {
        Object propertiesConfiguration;
        Properties conf = new Properties();
        ByteArrayInputStream inputStream = null;
        try {
            if (ConfigUtils.isConfiguredByZoo() && StringUtils.isNotBlank((CharSequence)zooPath)) {
                logger.debug("Load config {} from zookeeper.", (Object)classPath);
                ZkProperties zkProperties = new ZkProperties(zooPath);
                inputStream = new ByteArrayInputStream(zkProperties.getPropertiesBytes());
                conf.load(new InputStreamReader((InputStream)inputStream, "UTF-8"));
            } else {
                logger.debug("Load config {} from classpath.", (Object)classPath);
                propertiesConfiguration = new PropertiesConfiguration(classPath);
                if (!propertiesConfiguration.isEmpty()) {
                    conf = new PropertiesAdaptor((PropertiesConfiguration)propertiesConfiguration);
                } else {
                    conf.load(ConfigUtils.class.getResourceAsStream(classPath));
                }
            }
            propertiesConfiguration = conf;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("\u52a0\u8f7d\u914d\u7f6e\u5931\u8d25", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return propertiesConfiguration;
    }

    private static URL getClassPath(String classPath) {
        URL path = null;
        try {
            path = ConfigUtils.class.getClassLoader().getResource(classPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    private static class PropertiesAdaptor
    extends Properties {
        private PropertiesConfiguration propertiesConfiguration;

        public PropertiesAdaptor(PropertiesConfiguration propertiesConfiguration) {
            this.propertiesConfiguration = propertiesConfiguration;
        }

        @Override
        public String getProperty(String key) {
            return this.getProperty(key, null);
        }

        @Override
        public String getProperty(String key, String defaultValue) {
            return this.propertiesConfiguration == null ? null : this.propertiesConfiguration.getString(key, defaultValue);
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.propertiesConfiguration == null || this.propertiesConfiguration.isEmpty();
        }

        @Override
        public synchronized String toString() {
            ArrayList keyAndValue = Lists.newArrayList();
            Iterator keys = this.propertiesConfiguration.getKeys();
            while (keys != null && keys.hasNext()) {
                String key = (String)keys.next();
                keyAndValue.add(key + ":" + this.propertiesConfiguration.getProperty(key));
            }
            return this.propertiesConfiguration == null ? null : StringUtils.join((Iterable)keyAndValue, (String)",");
        }
    }
}

