/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.util;

import com.depotnearby.util.TrustManagerImpl;
import it.sauronsoftware.ftp4j.FTPClient;
import it.sauronsoftware.ftp4j.FTPFile;
import java.io.File;
import java.io.FileFilter;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.codelogger.utils.ArrayUtils;
import org.codelogger.utils.FileUtils;
import org.codelogger.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String server;
    private Integer port = 21;
    private String user;
    private String password;
    private Boolean sslEnable = false;
    private FTPClient ftpClient;

    public FtpUtil(String server) {
        this.server = server;
    }

    public FtpUtil(String server, String user, String password) {
        this.server = server;
        this.user = user;
        this.password = password;
    }

    public FtpUtil(String server, Integer port, String user, String password) {
        this.server = server;
        this.port = port;
        this.user = user;
        this.password = password;
    }

    private synchronized FTPClient getFtpClient() {
        if (this.ftpClient == null) {
            this.ftpClient = new FTPClient();
            try {
                if (this.sslEnable.booleanValue()) {
                    TrustManager[] trustManager = new TrustManager[]{new TrustManagerImpl()};
                    SSLContext sslContext = SSLContext.getInstance("SSL");
                    sslContext.init(null, trustManager, new SecureRandom());
                    SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                    this.ftpClient.setSSLSocketFactory(sslSocketFactory);
                    this.ftpClient.setSecurity(2);
                }
                this.ftpClient.setType(2);
                this.ftpClient.setCharset("UTF-8");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.ftpClient.isConnected()) {
            try {
                this.ftpClient.connect(this.server, this.port.intValue());
                this.ftpClient.login(this.user, this.password);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.ftpClient;
    }

    public FTPFile[] listDirectory(String targetDirectory) {
        FTPClient ftpClient = this.getFtpClient();
        try {
            return ftpClient.list(targetDirectory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void upload(String targetDirectory, File file) {
        block13: {
            if (file == null) {
                return;
            }
            FTPClient ftpClient = this.getFtpClient();
            try {
                String finalTargetDirectory = FtpUtil.getJoinDirectoryPath(targetDirectory);
                ftpClient.changeDirectory("/");
                if (finalTargetDirectory.length() > 1) {
                    String[] directories = finalTargetDirectory.split("/");
                    for (String directory : directories) {
                        if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)directory)) continue;
                        try {
                            ftpClient.createDirectory(directory);
                        }
                        catch (Exception e) {
                            this.logger.debug("Create directory:'{}' failed, maybe exist.", (Object)directory, (Object)e);
                        }
                        ftpClient.changeDirectory(directory);
                    }
                }
                if (file.isDirectory()) {
                    try {
                        ftpClient.createDirectory(file.getName());
                    }
                    catch (Exception e) {
                        this.logger.debug("Create directory:'{}' failed, maybe exist.", (Object)file.getName(), (Object)e);
                    }
                    ftpClient.changeDirectory(file.getName());
                    Object[] subFiles = file.listFiles();
                    if (ArrayUtils.isNotEmpty((Object[])subFiles)) {
                        for (Object subFile : subFiles) {
                            if (((File)subFile).isDirectory()) {
                                this.upload(finalTargetDirectory + file.getName(), (File)subFile);
                                ftpClient.changeDirectory(finalTargetDirectory + file.getName());
                                continue;
                            }
                            this.updateFile(ftpClient, (File)subFile);
                        }
                    }
                    break block13;
                }
                this.updateFile(ftpClient, file);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void updateFile(FTPClient ftpClient, File file) {
        try {
            ftpClient.upload(file);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void download(String ftpFilePath, File target) {
        FTPClient ftpClient = this.getFtpClient();
        try {
            FTPFile[] ftpFiles;
            for (FTPFile ftpFile : ftpFiles = ftpClient.list(ftpFilePath)) {
                Object fixTarget;
                NameFileFilter nameFileFilter;
                Object[] targetDirector;
                if (ftpFile.getType() == 0) {
                    if (target.isFile()) {
                        this.downloadFile(ftpClient, ftpFilePath, target);
                        continue;
                    }
                    this.downloadFile(ftpClient, ftpFilePath.endsWith(ftpFile.getName()) ? ftpFilePath : FtpUtil.getJoinDirectoryPath(ftpFilePath, ftpFile.getName()), new File(target.getPath() + "/" + ftpFile.getName()));
                    continue;
                }
                if (target.isFile()) {
                    throw new RuntimeException("Can not down an directory to a file.");
                }
                if (!target.exists()) {
                    FileUtils.createDirectory((File)target);
                }
                if (ArrayUtils.isEmpty((Object[])(targetDirector = target.listFiles((FileFilter)(nameFileFilter = new NameFileFilter(ftpFile.getName())))))) {
                    fixTarget = new File(target.getPath() + "/" + ftpFile.getName());
                    ((File)fixTarget).mkdir();
                } else {
                    fixTarget = targetDirector[0];
                }
                this.download(FtpUtil.getJoinDirectoryPath(ftpFilePath, ((File)fixTarget).getName()), (File)fixTarget);
                ftpClient.changeDirectory(ftpFilePath);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void downloadFile(FTPClient ftpClient, String ftpFilePath, File target) {
        try {
            this.logger.debug("Download ftp file '{}' to local file '{}'", (Object)ftpFilePath, (Object)target);
            ftpClient.download(ftpFilePath, target);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteFile(String ftpFilePath) {
        FTPClient ftpClient = this.getFtpClient();
        try {
            ftpClient.deleteFile(ftpFilePath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteDirectory(String ftpDirectory) {
        throw new RuntimeException("Method not support.");
    }

    public static String getJoinDirectoryPath(String ... directorPaths) {
        String finalDirectorPath = "";
        if (ArrayUtils.isNotEmpty((Object[])directorPaths)) {
            for (String directorPath : directorPaths) {
                if (directorPath.startsWith("/")) {
                    if (finalDirectorPath.endsWith("/")) {
                        finalDirectorPath = finalDirectorPath + directorPath.substring(1);
                        continue;
                    }
                    finalDirectorPath = finalDirectorPath + directorPath;
                    continue;
                }
                finalDirectorPath = finalDirectorPath.endsWith("/") ? finalDirectorPath + directorPath : finalDirectorPath + "/" + directorPath;
            }
        }
        if (StringUtils.isNotBlank((String)finalDirectorPath)) {
            return finalDirectorPath.endsWith("/") ? finalDirectorPath.substring(0, finalDirectorPath.length() - 1) : finalDirectorPath;
        }
        return "/";
    }

    public void enableSslEnable() {
        this.sslEnable = true;
    }
}

