/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.util;

import java.util.TimerTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleTimerDataLoader<T> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private String name;
    private int corePoolSize;
    private final ScheduledThreadPoolExecutor schedual = new ScheduledThreadPoolExecutor(this.corePoolSize, new ThreadFactory(){
        private AtomicInteger atoInteger = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName(SimpleTimerDataLoader.this.name + "-Thread " + this.atoInteger.getAndIncrement());
            return t;
        }
    });
    private T data;

    public T getData() {
        return this.data;
    }

    protected abstract T loadDataByTimerTask();

    public final void updateData(T t) {
        this.data = t;
    }

    public SimpleTimerDataLoader(String name, int corePoolSize, long delay, long period, TimeUnit timeUnit, Boolean loadDataImmediately) {
        this(delay, period, timeUnit);
        this.name = name;
        this.corePoolSize = corePoolSize;
        if (loadDataImmediately.booleanValue()) {
        }
    }

    private SimpleTimerDataLoader(long delay, long period, TimeUnit timeUnit) {
        this.schedual.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                SimpleTimerDataLoader.this.doLoadData();
            }
        }, delay, period, timeUnit);
    }

    private void doLoadData() {
        try {
            this.data = this.loadDataByTimerTask();
        }
        catch (Throwable e) {
            this.logger.info("Load data failed.", e);
        }
    }
}

