/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.util;

import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHParameterSpec;
import org.apache.commons.lang3.tuple.MutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHTokenUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DHTokenUtils.class);
    private static AlgorithmParameterGenerator paramGen;
    public static final String DEFAULT_TOKEN = "13196520348498300509170571968898643110806720751219744788129636326922565480984492185368038375211941297871289403061486510064429072584259746910423138674192557,6849211231874234332173554215962568648211715948614349192108760170867674332076420634857278025209099493881977517436387566623834457627945222750416199306671083";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MutablePair<BigInteger, BigInteger> generate() {
        long startTime = System.currentTimeMillis();
        try {
            AlgorithmParameters params = paramGen.generateParameters();
            DHParameterSpec dhSpec = params.getParameterSpec(DHParameterSpec.class);
            MutablePair mutablePair = new MutablePair((Object)dhSpec.getP(), (Object)dhSpec.getG());
            return mutablePair;
        }
        catch (InvalidParameterSpecException s) {
            s.printStackTrace();
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("time cost: {} ms", (Object)(System.currentTimeMillis() - startTime));
            }
        }
        return null;
    }

    public static String serialize(MutablePair<BigInteger, BigInteger> pair) {
        return String.valueOf(pair.getLeft()) + ',' + pair.getRight();
    }

    public static MutablePair<String, String> deserialize(String token) {
        String[] arr = token.split(",");
        if (arr.length == 2) {
            return new MutablePair((Object)arr[0], (Object)arr[1]);
        }
        return null;
    }

    static {
        try {
            paramGen = AlgorithmParameterGenerator.getInstance("DH");
            paramGen.init(512);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

