/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.codelogger.utils.MathUtils;
import org.codelogger.utils.StringUtils;

public class JsonUtil {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static <T> T json2Obj(String jsonStr, Class<T> clazz) {
        if (jsonStr == null) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(jsonStr, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException("Json\u53cd\u5e8f\u5217\u5316\u51fa\u9519", e);
        }
    }

    public static String obj2Json(Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException("Json\u5e8f\u5217\u5316\u51fa\u9519", e);
        }
    }

    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return OBJECT_MAPPER.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public static Object json2RespVo(String content, Class clazzResp, Class clazzItem) {
        if (StringUtils.isNotBlank((String)content)) {
            return null;
        }
        JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(clazzResp, new Class[]{clazzItem});
        try {
            System.out.println(javaType == null);
            return OBJECT_MAPPER.readValue(content, javaType);
        }
        catch (Exception e) {
            throw new RuntimeException("Json\u53cd\u5e8f\u5217\u5316\u51fa\u9519", e);
        }
    }

    public static <T> List<T> json2ObjList(String jsonStr, Class<T> clazz) {
        if (jsonStr == null) {
            return null;
        }
        JavaType javaType = JsonUtil.getCollectionType(ArrayList.class, clazz);
        try {
            return (List)OBJECT_MAPPER.readValue(jsonStr, javaType);
        }
        catch (Exception e) {
            throw new RuntimeException("Json\u53cd\u5e8f\u5217\u5316\u51fa\u9519", e);
        }
    }

    public static <T> T json2Obj(String content, Class<T> clazzItem, Class ... classes) {
        if (StringUtils.isBlank((String)content)) {
            return null;
        }
        JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(clazzItem, classes);
        try {
            return (T)OBJECT_MAPPER.readValue(content, javaType);
        }
        catch (Exception e) {
            throw new RuntimeException("Json\u53cd\u5e8f\u5217\u5316\u51fa\u9519", e);
        }
    }

    public static <T> List<T> jsonByte2ObjList(byte[] jsonByte, Class<T> clazz) {
        if (jsonByte == null || jsonByte.length == 0) {
            return null;
        }
        JavaType javaType = JsonUtil.getCollectionType(ArrayList.class, clazz);
        try {
            return (List)OBJECT_MAPPER.readValue(jsonByte, javaType);
        }
        catch (Exception e) {
            throw new RuntimeException("Json\u53cd\u5e8f\u5217\u5316\u51fa\u9519", e);
        }
    }

    public static void printObjectJsonDemo(Object obj) {
        JsonUtil.fillValueToField(obj, true);
        System.out.println(JsonUtil.obj2Json(obj));
    }

    private static void fillValueToField(Object obj, Boolean isFirst) {
        if (obj == null) {
            System.out.println("null");
        } else {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = obj.getClass().getDeclaredFields()) {
                String fieldName = declaredField.getName();
                if (Modifier.isFinal(declaredField.getModifiers())) continue;
                declaredField.setAccessible(true);
                Type genericType = declaredField.getGenericType();
                try {
                    ConcurrentLinkedQueue value = declaredField.get(obj);
                    if (value == null) {
                        if (genericType == Integer.class || genericType == Integer.TYPE) {
                            value = MathUtils.randomInt();
                        } else if (genericType == Long.class || genericType == Long.TYPE) {
                            value = MathUtils.randomLong();
                        } else if (genericType == Double.class || genericType == Double.TYPE) {
                            value = MathUtils.randomDouble();
                        } else if (genericType == String.class) {
                            value = "valueOf" + StringUtils.firstCharToUpperCase((String)fieldName);
                        } else if (genericType == Boolean.class || genericType == Boolean.TYPE) {
                            value = MathUtils.randomInt() % 2 == 0;
                        } else if (genericType == Byte.class || genericType == Byte.TYPE) {
                            value = String.valueOf(StringUtils.getRandomAlphabetic()).getBytes()[0];
                        } else if (genericType == Short.class || genericType == Short.TYPE) {
                            value = (short)MathUtils.randomInt((int)1, (int)9);
                        } else if (genericType == Character.class || genericType == Character.TYPE) {
                            value = Character.valueOf(StringUtils.getRandomAlphabetic());
                        } else if (genericType == BigDecimal.class) {
                            value = new BigDecimal(MathUtils.randomInt());
                        } else if (genericType == List.class) {
                            value = Lists.newArrayList();
                        } else if (genericType == Set.class) {
                            value = Sets.newHashSet();
                        } else if (genericType == Map.class) {
                            value = Maps.newHashMap();
                        } else if (genericType == Queue.class) {
                            value = new ConcurrentLinkedQueue();
                        }
                        if (value == null && isFirst.booleanValue()) {
                            try {
                                value = Class.forName(genericType.toString().split("\\s")[1]).newInstance();
                                JsonUtil.fillValueToField(value, false);
                            }
                            catch (Exception ignored) {
                                ignored.printStackTrace();
                            }
                        }
                    } else if (isFirst.booleanValue()) {
                        try {
                            JsonUtil.fillValueToField(value, false);
                        }
                        catch (Exception ignored) {
                            ignored.printStackTrace();
                        }
                    }
                    if (value == null) continue;
                    declaredField.set(obj, value);
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
            }
        }
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

