/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class QRCodeUtil {
    public static final String QRCODE_DEFAULT_CHARSET = "UTF-8";
    public static final int QRCODE_DEFAULT_HEIGHT = 300;
    public static final int QRCODE_DEFAULT_WIDTH = 300;
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;
    private static final String FORMAT = "png";

    public static void getQrcode(String content, File file) throws IOException {
        HashMap<EncodeHintType, Object> hint = new HashMap<EncodeHintType, Object>();
        hint.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hint.put(EncodeHintType.CHARACTER_SET, QRCODE_DEFAULT_CHARSET);
        BufferedImage bufferedImage = QRCodeUtil.createQRCode(content, QRCODE_DEFAULT_CHARSET, hint, 300, 300);
        ImageIO.write((RenderedImage)bufferedImage, FORMAT, file);
    }

    public static BufferedImage createQRCode(String data, String charset, Map<EncodeHintType, ?> hint, int width, int height) {
        try {
            BitMatrix matrix = new MultiFormatWriter().encode(new String(data.getBytes(charset), charset), BarcodeFormat.QR_CODE, width, height, hint);
            return QRCodeUtil.toBufferedImage(matrix);
        }
        catch (WriterException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static BufferedImage toBufferedImage(BitMatrix matrix) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }
}

