package com.depotnearby.search.es.entities;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang.StringUtils;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldIndex;
import org.springframework.data.elasticsearch.annotations.FieldType;

@Document(indexName = "smp_dealerproductprice", type = "dealerproductpriceinfo", refreshInterval = "3s")
public class DealerProductPriceEntity implements Serializable{
	
	 public static final String GROUPBY_FLAG_SPLIT=":";
	 public static final String ES_TYPE_PREFIX="price_";
	
	    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
		@Id
	    @Field(type = FieldType.String)
	    private String id ;
	    /** 经销商编码 */
	    @Field(type = FieldType.String, index = FieldIndex.not_analyzed, store = true)
	    private String dealerCode;
	    /** 经销商名称 */
	    @Field(type = FieldType.String, index = FieldIndex.analyzed, store = true, analyzer = "ik", searchAnalyzer = "ik_smart")
	    private String dealerName;
	    /** 产品编码 */
	    @Field(type = FieldType.String, index = FieldIndex.not_analyzed, store = true)
	    private String productCode;
	    /** 产品名称 */
	    @Field(type = FieldType.String, index = FieldIndex.analyzed, store = true, analyzer = "ik", searchAnalyzer = "ik_smart")
	    private String productName;
	    /** 产品协议状态 */
	    @Field(type = FieldType.String, index = FieldIndex.not_analyzed, store = true)
	    private String productStatus;
	    /** 终端等级编码 */
	    @Field(type = FieldType.String, index = FieldIndex.not_analyzed, store = true)
	    private String terminalLevelCode;
	    /** 终端等级 */
	    @Field(type = FieldType.String, index = FieldIndex.analyzed, store = true, analyzer = "ik", searchAnalyzer = "ik_smart")
	    private String terminalLevelName;
	    /** 终端编码 */
	    @Field(type = FieldType.String,index = FieldIndex.not_analyzed, store = true)
	    private String terminalCode;
	    /** 终端名称 */
	    @Field(type = FieldType.String, index = FieldIndex.analyzed, store = true, analyzer = "ik", searchAnalyzer = "ik_smart")
	    private String terminalName;
	    /** 销售红线价格 */
	    @Field(type = FieldType.Double,index = FieldIndex.not_analyzed, store = true)
	    private Double redPrice;
	    /** 销售价格 */
	    @Field(type = FieldType.Double,index = FieldIndex.not_analyzed,  store = true)
	    private Double price;
	    /** 单位编码 */
	    @Field(type = FieldType.String, index = FieldIndex.not_analyzed, store = true)
	    private String unitCode;
	    /** 上下架状态 */
	    @Field(type = FieldType.Boolean,index = FieldIndex.not_analyzed, store = true)
	    private Boolean putWayStatus;
	    /** 单位名称 */
	    @Field(type = FieldType.String,index = FieldIndex.analyzed, store = true, analyzer = "ik", searchAnalyzer = "ik_smart")
	    private String unit;
	    /** 对应关系 */
	    @Field(type = FieldType.Double, index = FieldIndex.not_analyzed, store = true)
	    private Double scale;
	    /** 是否手动维护 */
	    @Field(type = FieldType.Boolean,index = FieldIndex.not_analyzed,  store = true)
	    private Boolean isMaintain;
	    
	    /**价格等级  1-经销商+产品  2-产品+终端等级  3-产品+终端**/
	    @Field(type = FieldType.Integer,index = FieldIndex.not_analyzed,  store = true)
	    private Integer priceLevel=1;
	    /**价格分组标示  经销商编码:产品编码:单位编码**/
	    @Field(type = FieldType.String,index = FieldIndex.not_analyzed,  store = true)
	    private String gorupByFlag;
	    /**
	     * 创建人
	     */
	    @Field(type = FieldType.String, index = FieldIndex.not_analyzed, store = true)
	    private String createBy;
	    /**
	     * 创建人名称
	     */
	    @Field(type = FieldType.String, store = true)
	    private String createByName;
	    /**
	     * 创建时间
	     */
	    @Field(type = FieldType.Date,index = FieldIndex.not_analyzed, store = true)
	    private Date createDate;
	    /**
	     * 修改人
	     */
	    @Field(type = FieldType.String, index = FieldIndex.not_analyzed, store = true)
	    private String updateBy;
	    /**
	     * 修改人名称
	     */
	    @Field(type = FieldType.String, index = FieldIndex.analyzed, store = true)
	    private String updateByName;
	    /**
	     * 修改时间
	     */
	    @Field(type = FieldType.Date, index = FieldIndex.not_analyzed,store = true)
	    private Date updateDate;
	    /**产品类型**/
	    @Field(type = FieldType.String, index = FieldIndex.not_analyzed,store = true)
	     private String categoryCode;
	    @Field(type = FieldType.String, index = FieldIndex.analyzed, store = true, analyzer = "ik", searchAnalyzer = "ik_smart")
	     private String categoryName;
	    
	    /**产品品牌*/
	    @Field(type = FieldType.String, index = FieldIndex.not_analyzed, store = true)
	     private String brandCode;
	    @Field(type = FieldType.String, index = FieldIndex.analyzed, store = true, analyzer = "ik", searchAnalyzer = "ik_smart")
	     private String brandName;
	    
	    /**产品系列**/
	    @Field(type = FieldType.String,index = FieldIndex.not_analyzed, store = true)
	     private String seriesCode;
	    @Field(type = FieldType.String, index = FieldIndex.analyzed, store = true, analyzer = "ik", searchAnalyzer = "ik_smart")
	     private String seriesName;
	    
	    /**产品大类**/
	    @Field(type = FieldType.String,index = FieldIndex.not_analyzed, store = true)
	     private String bigCategoryCode;
	    @Field(type = FieldType.String, index = FieldIndex.analyzed, store = true, analyzer = "ik", searchAnalyzer = "ik_smart")
	     private String bigCategoryName;
	    /**产品小类*/

	    @Field(type = FieldType.String,index = FieldIndex.not_analyzed,  store = true)
	     private String smallCategoryCode;
	    @Field(type = FieldType.String, index = FieldIndex.analyzed, store = true, analyzer = "ik", searchAnalyzer = "ik_smart")
	     private String smallCategoryName;
	    /**香型名称*/
	    @Field(type = FieldType.String, index = FieldIndex.not_analyzed, store = true)
	    private String flavor;
	    
		public String getId() {
			return id;
		}
		public void setId(String id) {
			this.id = id;
		}
		public String getDealerCode() {
			return dealerCode;
		}
		public void setDealerCode(String dealerCode) {
			this.dealerCode = dealerCode;
		}
		public String getDealerName() {
			return dealerName;
		}
		public void setDealerName(String dealerName) {
			this.dealerName = dealerName;
		}
		public String getProductCode() {
			return productCode;
		}
		public void setProductCode(String productCode) {
			this.productCode = productCode;
		}
		public String getProductName() {
			return productName;
		}
		public void setProductName(String productName) {
			this.productName = productName;
		}
		public String getProductStatus() {
			return productStatus;
		}
		public void setProductStatus(String productStatus) {
			this.productStatus = productStatus;
		}
		public String getTerminalLevelCode() {
			return terminalLevelCode;
		}
		public void setTerminalLevelCode(String terminalLevelCode) {
			this.terminalLevelCode = terminalLevelCode;
		}
		public String getTerminalLevelName() {
			return terminalLevelName;
		}
		public void setTerminalLevelName(String terminalLevelName) {
			this.terminalLevelName = terminalLevelName;
		}
		public String getTerminalCode() {
			return terminalCode;
		}
		public void setTerminalCode(String terminalCode) {
			this.terminalCode = terminalCode;
		}
		public String getTerminalName() {
			return terminalName;
		}
		public void setTerminalName(String terminalName) {
			this.terminalName = terminalName;
		}
		public Double getRedPrice() {
			return redPrice;
		}
		public void setRedPrice(Double redPrice) {
			this.redPrice = redPrice;
		}
		public Double getPrice() {
			return price;
		}
		public void setPrice(Double price) {
			this.price = price;
		}
		public String getUnitCode() {
			return unitCode;
		}
		public void setUnitCode(String unitCode) {
			this.unitCode = unitCode;
		}
		public Boolean getPutWayStatus() {
			return putWayStatus;
		}
		public void setPutWayStatus(Boolean putWayStatus) {
			this.putWayStatus = putWayStatus;
		}
		public String getUnit() {
			return unit;
		}
		public void setUnit(String unit) {
			this.unit = unit;
		}
		public Double getScale() {
			return scale;
		}
		public void setScale(Double scale) {
			this.scale = scale;
		}
		public Boolean getIsMaintain() {
			return isMaintain;
		}
		public void setIsMaintain(Boolean isMaintain) {
			this.isMaintain = isMaintain;
		}
		public String getCreateBy() {
			return createBy;
		}
		public void setCreateBy(String createBy) {
			this.createBy = createBy;
		}
		public String getCreateByName() {
			return createByName;
		}
		public void setCreateByName(String createByName) {
			this.createByName = createByName;
		}
		public Date getCreateDate() {
			return createDate;
		}
		public void setCreateDate(Date createDate) {
			this.createDate = createDate;
		}
		public Integer getPriceLevel() {
			return priceLevel;
		}
		public void setPriceLevel(Integer priceLevel) {
			this.priceLevel = priceLevel;
		}
		public String getUpdateBy() {
			return updateBy;
		}
		public void setUpdateBy(String updateBy) {
			this.updateBy = updateBy;
		}
		public String getUpdateByName() {
			return updateByName;
		}
		public void setUpdateByName(String updateByName) {
			this.updateByName = updateByName;
		}
		public Date getUpdateDate() {
			return updateDate;
		}
		public void setUpdateDate(Date updateDate) {
			this.updateDate = updateDate;
		}
		public String getCategoryCode() {
			return categoryCode;
		}
		public void setCategoryCode(String categoryCode) {
			this.categoryCode = categoryCode;
		}
		public String getCategoryName() {
			return categoryName;
		}
		public void setCategoryName(String categoryName) {
			this.categoryName = categoryName;
		}
		public String getBrandCode() {
			return brandCode;
		}
		public void setBrandCode(String brandCode) {
			this.brandCode = brandCode;
		}
		public String getBrandName() {
			return brandName;
		}
		public void setBrandName(String brandName) {
			this.brandName = brandName;
		}
		public String getSeriesCode() {
			return seriesCode;
		}
		public void setSeriesCode(String seriesCode) {
			this.seriesCode = seriesCode;
		}
		public String getSeriesName() {
			return seriesName;
		}
		public void setSeriesName(String seriesName) {
			this.seriesName = seriesName;
		}
		public String getBigCategoryCode() {
			return bigCategoryCode;
		}
		public void setBigCategoryCode(String bigCategoryCode) {
			this.bigCategoryCode = bigCategoryCode;
		}
		public String getBigCategoryName() {
			return bigCategoryName;
		}
		public void setBigCategoryName(String bigCategoryName) {
			this.bigCategoryName = bigCategoryName;
		}
		public String getSmallCategoryCode() {
			return smallCategoryCode;
		}
		public void setSmallCategoryCode(String smallCategoryCode) {
			this.smallCategoryCode = smallCategoryCode;
		}
		public String getSmallCategoryName() {
			return smallCategoryName;
		}
		public void setSmallCategoryName(String smallCategoryName) {
			this.smallCategoryName = smallCategoryName;
		}
		public String getFlavor() {
			return flavor;
		}
		public void setFlavor(String flavor) {
			this.flavor = flavor;
		}
		public String getGorupByFlag() {
			return gorupByFlag;
		}
		public void setGorupByFlag(String gorupByFlag) {
			this.gorupByFlag = gorupByFlag;
		}
		
		/***
		 * 获取types
		 * @return
		 */
		public String getEsTypesName(){
			return ES_TYPE_PREFIX+StringUtils.trim(dealerCode);
		}
		/***
		 * 获取Index
		 * @return
		 */
		public String getEsIndexName(){
			return "smp_dealerproductprice";
		}
	    
	    
		
	    /** 
	     * 封装对象的Json信息 
	     * 
	     * @return 
	     * @throws IOException 
	     */  
	    public  XContentBuilder getXContentBuilder() throws IOException {  
	        return XContentFactory.jsonBuilder()  
	        		.startObject()
	        		.field("id",id)
	        		.field("dealerCode",StringUtils.trim(this.dealerCode))
	        		.field("price",this.price)
	        		.field("dealerName",this.dealerName)
	        		.field("productCode",StringUtils.trim(productCode))
	        		.field("productName",productName)
	        		.field("productStatus",productStatus)
	        		.field("terminalLevelCode",terminalLevelCode)
	        		.field("terminalLevelName",terminalLevelName)
	        		.field("terminalCode",StringUtils.trim(terminalCode))
	        		.field("terminalName",terminalName)
	        		.field("redPrice",redPrice)
	        		.field("unitCode",unitCode)
	        		.field("putWayStatus",putWayStatus)
	        		.field("unit",unit)
	        		.field("scale",scale)
	        		.field("isMaintain",isMaintain)
	        		.field("priceLevel",priceLevel)
	        		.field("categoryCode",categoryCode)
	        		.field("categoryName",categoryName)
	        		.field("updateDate",updateDate)
	        		.field("brandCode",brandCode)
	        		.field("brandName",brandName)
	        		.field("seriesCode",seriesCode)
	        		.field("seriesName",seriesName)
	        		.field("bigCategoryCode",bigCategoryCode)
	        		.field("bigCategoryName",bigCategoryName)
	        		.field("smallCategoryCode",smallCategoryCode)
	        		.field("smallCategoryName",smallCategoryName)
	        		.field("flavor",flavor)
	        		.endObject();
	    }  
	    
}
