package com.depotnearby.search.es.util;

import javax.annotation.Resource;

import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;

public class EsManagerHandler{
	
	private static Logger logger=LoggerFactory.getLogger(EsManagerHandler.class);
	
	
	@Resource(name="elasticsearchTemplate")
	private ElasticsearchOperations elasticsearchOperations;
	
	
	
	/**
	 * 写入文档
	 * @param index
	 * @param type
	 * @param id
	 * @param source
	 */
	public void createDoucment(String index,String type,String id,XContentBuilder source){
	        // 存json入索引中
	        IndexResponse response = elasticsearchOperations.getClient().prepareIndex(index, type, id).setSource(source).get();
	}
	
	
	/**
	 * 
	 * @param index
	 * @param type
	 * @param id
	 */
	public void deleteDocument(String index,String type,String id){
		elasticsearchOperations.getClient().prepareDelete(index, type, id).get();
	}
	
	
	

}
