/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.search.es.entities;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldIndex;
import org.springframework.data.elasticsearch.annotations.FieldType;

@Document(indexName="smp_dealerproductprice", type="dealerproductpriceinfo", refreshInterval="3s")
public class DealerProductPriceEntity
implements Serializable {
    public static final String GROUPBY_FLAG_SPLIT = ":";
    public static final String ES_TYPE_PREFIX = "price_";
    private static final long serialVersionUID = 1L;
    @Id
    @Field(type=FieldType.String)
    private String id;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed, store=true)
    private String dealerCode;
    @Field(type=FieldType.String, index=FieldIndex.analyzed, store=true, analyzer="ik", searchAnalyzer="ik_smart")
    private String dealerName;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed, store=true)
    private String productCode;
    @Field(type=FieldType.String, index=FieldIndex.analyzed, store=true, analyzer="ik", searchAnalyzer="ik_smart")
    private String productName;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed, store=true)
    private String productStatus;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed, store=true)
    private String terminalLevelCode;
    @Field(type=FieldType.String, index=FieldIndex.analyzed, store=true, analyzer="ik", searchAnalyzer="ik_smart")
    private String terminalLevelName;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed, store=true)
    private String terminalCode;
    @Field(type=FieldType.String, index=FieldIndex.analyzed, store=true, analyzer="ik", searchAnalyzer="ik_smart")
    private String terminalName;
    @Field(type=FieldType.Double, index=FieldIndex.not_analyzed, store=true)
    private Double redPrice;
    @Field(type=FieldType.Double, index=FieldIndex.not_analyzed, store=true)
    private Double price;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed, store=true)
    private String unitCode;
    @Field(type=FieldType.Boolean, index=FieldIndex.not_analyzed, store=true)
    private Boolean putWayStatus;
    @Field(type=FieldType.String, index=FieldIndex.analyzed, store=true, analyzer="ik", searchAnalyzer="ik_smart")
    private String unit;
    @Field(type=FieldType.Double, index=FieldIndex.not_analyzed, store=true)
    private Double scale;
    @Field(type=FieldType.Boolean, index=FieldIndex.not_analyzed, store=true)
    private Boolean isMaintain;
    @Field(type=FieldType.Integer, index=FieldIndex.not_analyzed, store=true)
    private Integer priceLevel = 1;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed, store=true)
    private String gorupByFlag;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed, store=true)
    private String createBy;
    @Field(type=FieldType.String, store=true)
    private String createByName;
    @Field(type=FieldType.Date, index=FieldIndex.not_analyzed, store=true)
    private Date createDate;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed, store=true)
    private String updateBy;
    @Field(type=FieldType.String, index=FieldIndex.analyzed, store=true)
    private String updateByName;
    @Field(type=FieldType.Date, index=FieldIndex.not_analyzed, store=true)
    private Date updateDate;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed, store=true)
    private String categoryCode;
    @Field(type=FieldType.String, index=FieldIndex.analyzed, store=true, analyzer="ik", searchAnalyzer="ik_smart")
    private String categoryName;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed, store=true)
    private String brandCode;
    @Field(type=FieldType.String, index=FieldIndex.analyzed, store=true, analyzer="ik", searchAnalyzer="ik_smart")
    private String brandName;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed, store=true)
    private String seriesCode;
    @Field(type=FieldType.String, index=FieldIndex.analyzed, store=true, analyzer="ik", searchAnalyzer="ik_smart")
    private String seriesName;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed, store=true)
    private String bigCategoryCode;
    @Field(type=FieldType.String, index=FieldIndex.analyzed, store=true, analyzer="ik", searchAnalyzer="ik_smart")
    private String bigCategoryName;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed, store=true)
    private String smallCategoryCode;
    @Field(type=FieldType.String, index=FieldIndex.analyzed, store=true, analyzer="ik", searchAnalyzer="ik_smart")
    private String smallCategoryName;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed, store=true)
    private String flavor;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDealerCode() {
        return this.dealerCode;
    }

    public void setDealerCode(String dealerCode) {
        this.dealerCode = dealerCode;
    }

    public String getDealerName() {
        return this.dealerName;
    }

    public void setDealerName(String dealerName) {
        this.dealerName = dealerName;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductStatus() {
        return this.productStatus;
    }

    public void setProductStatus(String productStatus) {
        this.productStatus = productStatus;
    }

    public String getTerminalLevelCode() {
        return this.terminalLevelCode;
    }

    public void setTerminalLevelCode(String terminalLevelCode) {
        this.terminalLevelCode = terminalLevelCode;
    }

    public String getTerminalLevelName() {
        return this.terminalLevelName;
    }

    public void setTerminalLevelName(String terminalLevelName) {
        this.terminalLevelName = terminalLevelName;
    }

    public String getTerminalCode() {
        return this.terminalCode;
    }

    public void setTerminalCode(String terminalCode) {
        this.terminalCode = terminalCode;
    }

    public String getTerminalName() {
        return this.terminalName;
    }

    public void setTerminalName(String terminalName) {
        this.terminalName = terminalName;
    }

    public Double getRedPrice() {
        return this.redPrice;
    }

    public void setRedPrice(Double redPrice) {
        this.redPrice = redPrice;
    }

    public Double getPrice() {
        return this.price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public String getUnitCode() {
        return this.unitCode;
    }

    public void setUnitCode(String unitCode) {
        this.unitCode = unitCode;
    }

    public Boolean getPutWayStatus() {
        return this.putWayStatus;
    }

    public void setPutWayStatus(Boolean putWayStatus) {
        this.putWayStatus = putWayStatus;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Double getScale() {
        return this.scale;
    }

    public void setScale(Double scale) {
        this.scale = scale;
    }

    public Boolean getIsMaintain() {
        return this.isMaintain;
    }

    public void setIsMaintain(Boolean isMaintain) {
        this.isMaintain = isMaintain;
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public String getCreateByName() {
        return this.createByName;
    }

    public void setCreateByName(String createByName) {
        this.createByName = createByName;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Integer getPriceLevel() {
        return this.priceLevel;
    }

    public void setPriceLevel(Integer priceLevel) {
        this.priceLevel = priceLevel;
    }

    public String getUpdateBy() {
        return this.updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    public String getUpdateByName() {
        return this.updateByName;
    }

    public void setUpdateByName(String updateByName) {
        this.updateByName = updateByName;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getCategoryCode() {
        return this.categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getBrandCode() {
        return this.brandCode;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }

    public String getBrandName() {
        return this.brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getSeriesCode() {
        return this.seriesCode;
    }

    public void setSeriesCode(String seriesCode) {
        this.seriesCode = seriesCode;
    }

    public String getSeriesName() {
        return this.seriesName;
    }

    public void setSeriesName(String seriesName) {
        this.seriesName = seriesName;
    }

    public String getBigCategoryCode() {
        return this.bigCategoryCode;
    }

    public void setBigCategoryCode(String bigCategoryCode) {
        this.bigCategoryCode = bigCategoryCode;
    }

    public String getBigCategoryName() {
        return this.bigCategoryName;
    }

    public void setBigCategoryName(String bigCategoryName) {
        this.bigCategoryName = bigCategoryName;
    }

    public String getSmallCategoryCode() {
        return this.smallCategoryCode;
    }

    public void setSmallCategoryCode(String smallCategoryCode) {
        this.smallCategoryCode = smallCategoryCode;
    }

    public String getSmallCategoryName() {
        return this.smallCategoryName;
    }

    public void setSmallCategoryName(String smallCategoryName) {
        this.smallCategoryName = smallCategoryName;
    }

    public String getFlavor() {
        return this.flavor;
    }

    public void setFlavor(String flavor) {
        this.flavor = flavor;
    }

    public String getGorupByFlag() {
        return this.gorupByFlag;
    }

    public void setGorupByFlag(String gorupByFlag) {
        this.gorupByFlag = gorupByFlag;
    }

    public String getEsTypesName() {
        return ES_TYPE_PREFIX + StringUtils.trim((String)this.dealerCode);
    }

    public String getEsIndexName() {
        return "smp_dealerproductprice";
    }

    public XContentBuilder getXContentBuilder() throws IOException {
        return XContentFactory.jsonBuilder().startObject().field("id", this.id).field("dealerCode", StringUtils.trim((String)this.dealerCode)).field("price", this.price).field("dealerName", this.dealerName).field("productCode", StringUtils.trim((String)this.productCode)).field("productName", this.productName).field("productStatus", this.productStatus).field("terminalLevelCode", this.terminalLevelCode).field("terminalLevelName", this.terminalLevelName).field("terminalCode", StringUtils.trim((String)this.terminalCode)).field("terminalName", this.terminalName).field("redPrice", this.redPrice).field("unitCode", this.unitCode).field("putWayStatus", (Object)this.putWayStatus).field("unit", this.unit).field("scale", this.scale).field("isMaintain", (Object)this.isMaintain).field("priceLevel", this.priceLevel).field("categoryCode", this.categoryCode).field("categoryName", this.categoryName).field("updateDate", this.updateDate).field("brandCode", this.brandCode).field("brandName", this.brandName).field("seriesCode", this.seriesCode).field("seriesName", this.seriesName).field("bigCategoryCode", this.bigCategoryCode).field("bigCategoryName", this.bigCategoryName).field("smallCategoryCode", this.smallCategoryCode).field("smallCategoryName", this.smallCategoryName).field("flavor", this.flavor).endObject();
    }
}

