/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.web.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codelogger.utils.ArrayUtils;
import org.codelogger.utils.StringUtils;

public class HttpServletHelper {
    public static final String X_FORWARDED_FOR = "X-FORWARDED-FOR";
    public static final String X_REAL_IP = "X-Real-IP";

    public static String getCookieValue(HttpServletRequest request, String key) {
        Object[] cookies = request.getCookies();
        if (ArrayUtils.isEmpty((Object[])cookies)) {
            return null;
        }
        String value = null;
        Object[] objectArray = cookies;
        int n = cookies.length;
        int n2 = 0;
        while (n2 < n) {
            Object cookie = objectArray[n2];
            if (cookie.getName().equals(key)) {
                value = cookie.getValue();
                break;
            }
            ++n2;
        }
        return value;
    }

    public static void putSessionValue(HttpServletRequest request, String key, Object value) {
        request.getSession().setAttribute(key, value);
    }

    public static <T> T getSessionValue(HttpServletRequest request, String key) {
        Object value = request.getSession().getAttribute(key);
        return (T)value;
    }

    public static boolean getBooleanValueFromSession(HttpServletRequest request, String key) {
        Boolean booleanValue = (Boolean)HttpServletHelper.getSessionValue(request, key);
        return booleanValue == null ? false : booleanValue;
    }

    public static void setCookie(HttpServletResponse response, String key, String value, int expireTime, String path) {
        Cookie cookie = new Cookie(key, value);
        cookie.setMaxAge(expireTime);
        cookie.setPath(path);
        response.addCookie(cookie);
    }

    public static String getClientIP(HttpServletRequest request) {
        String ipAddress = request.getHeader(X_FORWARDED_FOR);
        if (ipAddress == null) {
            String xRealIp = request.getHeader(X_REAL_IP);
            return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)xRealIp) ? request.getRemoteHost() : xRealIp;
        }
        return ipAddress;
    }

    public static String getRequestURIWithParameters(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String queryString = request.getQueryString();
        return StringUtils.isBlank((String)queryString) ? requestURI : String.format("%s?%s", requestURI, queryString);
    }

    public static Map<String, String> getHeaders(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        HashMap<String, String> headers = new HashMap<String, String>();
        while (headerNames.hasMoreElements()) {
            String nextHeader = headerNames.nextElement().toString();
            String nextHeaderValue = request.getHeader(nextHeader);
            headers.put(nextHeader, nextHeaderValue);
        }
        return headers;
    }

    public static Boolean isMobileDevices(HttpServletRequest request) {
        request.getHeader("");
        return false;
    }
}

