package com.ec.primus.component.model.base.enums;


import com.ec.primus.commons.enums.ValuableAndDescribableEnum;
import com.ec.primus.commons.enums.converter.BaseEnumValueAndDescriptionConverter;
import lombok.Getter;

import java.util.Objects;

/**
 * @author zhangcheng
 * @date 2016/12/16
 * @reviewer
 * @see
 */
@Getter
public enum CommonStatus implements ValuableAndDescribableEnum {
    ENABLE("启用", 1),

    DISABLE("禁用", 2);

    private int value;

    private String desc;

    CommonStatus(String desc, int value) {
        this.value = value;
        this.desc = desc;
    }

    public static CommonStatus toggle(CommonStatus commonStatus) {
        if (Objects.isNull(commonStatus)) {
            return null;
        }
        return commonStatus == CommonStatus.ENABLE ? CommonStatus.DISABLE : CommonStatus.ENABLE;
    }

    public boolean isEnable() {
        return this == ENABLE;
    }

    public static class Converter extends BaseEnumValueAndDescriptionConverter<CommonStatus> {
    }

    public static String toJsonString(){
        CommonStatus[] values = CommonStatus.values();
        String result = "{";
        for (int i = 0;i<values.length;i++) {
            if(i == values.length-1){
                result += "'" + values[i].toString() + "':'"+values[i].getDesc() + "'";
            }else{
                result += "'" + values[i].toString() + "':'"+values[i].getDesc() + "',";
            }
        }
        result += "}";
        return result;
    }
}
