package com.ec.primus.component.model.base.enums;


import com.ec.primus.commons.enums.ValuableAndDescribableEnum;
import com.ec.primus.commons.enums.converter.BaseEnumValueAndDescriptionConverter;
import lombok.Getter;

import java.util.Objects;

/**
 * 枚举:是/否
 * @author wan
 */
@Getter
public enum CommonYesOrNo implements ValuableAndDescribableEnum {

    YES("是",1),

    NO("否",0);

    private String desc;
    private int value;

    CommonYesOrNo(String desc, int value){
        this.value = value;
        this.desc = desc;
    }

    public static CommonYesOrNo toggle(CommonYesOrNo commonYesOrNo) {
        if (Objects.isNull(commonYesOrNo)) {
            return null;
        }
        return commonYesOrNo == CommonYesOrNo.YES ? CommonYesOrNo.YES : CommonYesOrNo.NO;
    }

    public boolean isEnable() {
        return this == NO;
    }

    public static class Converter extends BaseEnumValueAndDescriptionConverter<CommonYesOrNo> {
    }
}
