package com.ec.primus.component.model.base.exception;


import com.ec.primus.commons.exception.ExceptionType;

/**
 * Spring的事务针对这个及其子类异常，不会进行进行回滚。
 * <p>
 * Created by defei on 7/31/17.
 */
public class BizBusinessException extends BizCheckedException {

    private static final long serialVersionUID = 4984288360963210909L;

    public BizBusinessException(ExceptionType type, String message) {
        super(type, message);
    }

    public BizBusinessException(ExceptionType type) {
        this(type, type.getDescription());
    }

    public BizBusinessException(String message) {
        super(message);
    }

    public BizBusinessException(int exceptionCode, String message) {
        super(exceptionCode, message);
    }

    public BizBusinessException(int exceptionCode, String message, Throwable cause) {
        super(exceptionCode, message, cause);
    }

    public BizBusinessException(String message, Throwable cause) {
        super(message, cause);
    }
}
