package com.ec.primus.component.model.base.exception;


import com.ec.primus.commons.constant.SoaStatusCodes;
import com.ec.primus.commons.exception.BusinessException;
import com.ec.primus.commons.exception.ExceptionType;

/**
 * Spring的事务针对这个及其子类异常，不会进行进行回滚。
 * 必须根据具体的业务类型来定义子类,不能直接使用这个类
 * <p>
 * Created by defei on 7/31/17.
 */
public abstract class BizCheckedException extends Exception implements BusinessException {

    private static final long serialVersionUID = 5589536153777509425L;

    public BizCheckedException(ExceptionType type, String message) {

        super(message);
        this.code = type.getCode();
        this.description = type.getDescription();
    }

    public BizCheckedException(String message) {
        this.description = message;
    }

    public BizCheckedException(int exceptionCode, String message) {

        this.code = exceptionCode;
        this.description = message;
    }

    public BizCheckedException(int exceptionCode, String message, Throwable cause) {

        super(cause);
        this.code = exceptionCode;
        this.description = message;
    }

    public BizCheckedException(String message, Throwable cause) {

        super(cause);
        this.description = message;
    }

    @Override
    public int getCode() {
        return code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    private Integer code = SoaStatusCodes.COMMON_INTERNAL_EXCEPTION;

    private String description;
}
