package com.ec.primus.component.model.base.exception;

import com.ec.primus.commons.exception.ExceptionType;
import com.ec.primus.component.model.base.exception.annotation.BizExceptionResponse;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;

import java.util.List;
import java.util.Map;
import java.util.Set;

import static com.google.common.collect.Maps.newHashMap;
import static com.google.common.collect.Sets.newHashSet;

/**
 * @author defei
 * @since 7/6/18.
 */
public class BizExceptionResponseReader implements OperationBuilderPlugin {

    @Override
    public void apply(OperationContext context) {
        context.operationBuilder()
                .responseMessages(read(context));
    }

    @Override
    public boolean supports(DocumentationType documentationType) {
        return DocumentationType.SWAGGER_2 == documentationType;
    }

    protected Set<ResponseMessage> read(OperationContext context) {

        List<BizExceptionResponse> allApiResponses = context.findAllAnnotations(BizExceptionResponse.class);
        Set<ResponseMessage> responseMessages = newHashSet();

        Map<Integer, Class<? extends ExceptionType>> seenResponsesByCode = newHashMap();
        for (BizExceptionResponse userExceptionResponse : allApiResponses) {
            Class<? extends ExceptionType>[] apiResponseAnnotations = userExceptionResponse.value();
            for (Class<? extends ExceptionType> userExceptionType : apiResponseAnnotations) {
                if (userExceptionType.isEnum()) {

                    ExceptionType[] enumConstants = userExceptionType.getEnumConstants();
                    for (ExceptionType enumConstant : enumConstants) {

                        if (!seenResponsesByCode.containsKey(enumConstant.getCode())) {
                            seenResponsesByCode.put(enumConstant.getCode(), userExceptionType);
                            responseMessages.add(new ResponseMessageBuilder()
                                    .code(enumConstant.getCode())
                                    .message(enumConstant.getDescription())
                                    .build());
                        }
                    }

                }
            }
        }

        return responseMessages;
    }
}
