package com.ec.primus.component.model.payment.enums;


import com.ec.primus.commons.exception.ExceptionType;

/**
 * Created by defei on 9/22/17.
 */
public enum MerchantExceptionEnum implements ExceptionType {

    MERCHANT_NOT_FOUND(1004, "商户未找到");

    MerchantExceptionEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    private int code;

    private String description;

    @Override
    public int getCode() {
        return code;
    }

    @Override
    public String getDescription() {
        return description;
    }
}
