package com.ec.primus.component.model.payment.enums;


import com.ec.primus.commons.exception.ExceptionType;

/**
 * Created by defei on 9/22/17.
 */
public enum PaymentOrderExceptionEnum implements ExceptionType {

    PAYMENT_ORDER_IS_PAID(3000, "订单已支付"),

    PAYMENT_ORDER_IS_NOT_PAID(3001, "订单未支付"),

    PAYMENT_ORDER_IS_REFUNDED(3002, "订单已支付"),

    PAYMENT_ORDER_IS_EXPIRED(3003, "订单已过期"),

    PAYMENT_ORDER_NOT_FOUND(3004, "支付单未找到"),

    PAYMENT_ORDER_IS_NOT_PAYABLE(3005, "订单不可支付"),

    PAYMENT_ORDER_IS_NOT_REFUND(3006, "订单未进行退款"),

    PAYMENT_ORDER_IS_NOT_REFUNDABLE(3007, "订单不可退款");

    PaymentOrderExceptionEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    private int code;

    private String description;

    @Override
    public int getCode() {
        return code;
    }

    @Override
    public String getDescription() {
        return description;
    }
}
