package com.ec.primus.component.model.payment.enums;


import com.ec.primus.commons.enums.ValuableEnum;
import com.ec.primus.commons.enums.converter.BaseEnumValueConverter;

/**
 * Created by defei on 9/22/17.
 */
public enum PaymentStatusEnum implements ValuableEnum {

    DISCARD(1, "作废"),
    REFUND_FAILED(20, "退款失败"),
    REFUNDING(21, "退款中"),
    REFUNDED(22, "已退款"),
    CREATE_PAYMENT(40, "创建支付单"),
    PAID(100, "已支付");

    public static class Converter extends BaseEnumValueConverter<PaymentStatusEnum> {
    }


    public final int value;

    public final String desc;

    PaymentStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    @Override
    public int getValue() {
        return value;
    }
}
