package com.ec.primus.component.model.payment.service;


import com.ec.primus.component.model.payment.vo.paymentorder.*;

import java.util.List;

/**
 * @author defei
 * @data 6/23/18.
 */
public interface IPaymentServiceComponent {

    /**
     * 创建预支付单
     *
     * @param tradeTypeConfigurationJson 支付配置文件Json
     * @param reqVO {@link PaymentOrderCreateReqVO}
     */
    Object createPayment(String tradeTypeConfigurationJson, PaymentOrderCreateReqVO reqVO);

    /**
     * 判断是否已经支付
     */
    CommonPaidRespVo isPad(String configJson, String tradeNo, String mchOrderNo);

    /**
     * 退款
     *
     * @param configurationJson 配置文件Json
     * @param reqVO {@link PaymentOrderRefundReqVO}
     * @return {@link PaymentOrderRefundRespVO}
     */
    PaymentOrderRefundRespVO refund(String configurationJson, PaymentOrderRefundReqVO reqVO);

    /**
     * 退款
     *
     * @param configurationJson 配置文件Json
     * @param mchOrderNo 商户订单号
     * @param refundRequestNos 商户退款单号
     * @return {@link PaymentOrderRefundStatusCheckRespVO}
     */
    PaymentOrderRefundStatusCheckRespVO refundQuery(String configurationJson, String mchOrderNo, List<String> refundRequestNos);

    /**
     * 解析支付通知内容
     *
     * @param notifyData 通知内容
     * @return {@link PaymentPayNotifyParseResultVO}
     */
    PaymentPayNotifyParseResultVO parsePayNotify(String notifyData);

    /**
     * 验证支付通知内容
     *
     * @param configurationJson 配置文件Json
     * @param notifyData 通知内容
     * @return {@link PaymentPayNotifyValidateResultVO}
     */
    PaymentPayNotifyValidateResultVO validatePayNotify(String configurationJson, String notifyData);

    /**
     * 解析退款通知内容
     *
     * @param notifyData 通知内容
     * @return {@link PaymentRefundNotifyParseResultVO}
     */
    PaymentRefundNotifyParseResultVO parseRefundNotify(String notifyData);

    /**
     * 验证退款通知内容
     *
     * @param configurationJson 配置文件Json
     * @param notifyData 通知内容
     * @return {@link PaymentPayNotifyParseResultVO}
     */
    PaymentRefundNotifyValidateResultVO validateRefundNotify(String configurationJson, String notifyData);
}
