package com.ec.primus.component.model.payment.vo;


import com.ec.primus.component.model.payment.enums.PaymentScene;

/**
 * 支付渠道
 *
 * @author defei
 * @data 6/22/18.
 */
public interface ITradeType {

    /**
     * 支付渠道
     */
    IPaymentChannel getPaymentChannel();

    /**
     * 唯一标识
     */
    String getIdentity();

    /**
     * 支付场景
     * @return {@link PaymentScene}
     */
    PaymentScene getPaymentScene();

    /**
     * 名称
     */
    String getName();

    /**
     * 描述
     */
    String getDescription();

    /**
     * 配置文件Json示例
     */
    String getConfigurationJsonDemo();
}
