package com.ec.primus.component.model.payment.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 支付渠道VO
 *
 * @author defei
 * @data 6/22/18.
 */
@ApiModel("支付渠道")
@Getter
@Setter
public class PaymentChannelVO implements IPaymentChannel {

    @ApiModelProperty("唯一标识符")
    private String identity;

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("描述")
    private String description;

    public PaymentChannelVO() {
    }

    public PaymentChannelVO(String identity, String name, String description) {
        this.identity = identity;
        this.name = name;
        this.description = description;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
