package com.ec.primus.component.model.payment.vo;

import com.ec.primus.component.model.payment.enums.PaymentScene;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * @author defei
 * @data 6/22/18.
 */
@ApiModel("交易类型")
@Getter
@Setter
public class TradeTypeVO implements ITradeType {

    @ApiModelProperty("支付渠道")
    private PaymentChannelVO paymentChannel;

    @ApiModelProperty("唯一标识符")
    private String identity;

    @ApiModelProperty("支付场景")
    private PaymentScene paymentScene;

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("描述")
    private String description;

    /**
     * 配置示例
     */
    private String configurationJsonDemo;

    public TradeTypeVO() {
    }

    public TradeTypeVO(PaymentChannelVO paymentChannel, String identity, PaymentScene paymentScene, String name, String description, String configurationJsonDemo) {
        this.paymentChannel = paymentChannel;
        this.identity = identity;
        this.paymentScene = paymentScene;
        this.name = name;
        this.description = description;
        this.configurationJsonDemo = configurationJsonDemo;
    }

    /**
     * 配置文件Json示例
     */
    @Override
    public String getConfigurationJsonDemo() {
        return configurationJsonDemo;
    }

}
