package com.ec.primus.component.model.payment.vo.merchant;

import com.ec.primus.component.model.base.enums.CommonStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @author defei
 * @data 6/22/18.
 */
@ApiModel
@Data
public class MerchantUpdateReqVO {

    @ApiModelProperty("商户ID")
    @NotNull
    private String id;

    @ApiModelProperty("名称")
    @Size(min = 1, max = 40)
    private String name;

    @ApiModelProperty("备注")
    @Size(max = 255)
    private String remark;

    @ApiModelProperty("状态")
    @NotNull
    private CommonStatus status;
}
