package com.ec.primus.component.model.payment.vo.paymentorder;

import com.ec.primus.component.model.payment.constant.MerchantConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.sql.Timestamp;

/**
 * 支付单创建请求VO
 *
 * @author defei
 * @data 6/23/18.
 */
@ApiModel
@Getter
@Setter
public class PaymentOrderCreateReqVO {

    @ApiModelProperty(value = "商户ID")
    @Size(min = 1, max = 32)
    private String mchId = MerchantConstant.DEFAULT_MERCHANT_ID;

    @ApiModelProperty("商户端的订单号")
    @Size(min = 1, max = 64)
    private String mchOrderNo;

    @ApiModelProperty(value = "第三方支付的AppId")
    @Size(max = 64)
    private String appId;

    @ApiModelProperty(value = "卖家身份，可以为id或账号")
    @Size(max = 64)
    private String seller;

    @ApiModelProperty("当前支付单的title。如:小张南山店-超市 特惠买单")
    @Size(min = 1, max = 64)
    private String subject;

    @ApiModelProperty("当前支付单的详情。如:忘情水 250ml x 1")
    @Size(min = 1, max = 128)
    private String body;

    @ApiModelProperty("当前支付单的支付渠道")
    @Size(min = 1, max = 32)
    private String paymentChannel;

    @ApiModelProperty("当前支付单的交易类型")
    @Size(min = 1, max = 32)
    private String tradeType;

    @ApiModelProperty("支付过期时间, 在创建支付单的时候传入。")
    @NotNull
    private Timestamp expireTime;

    @ApiModelProperty("订单金额，单位:分")
    @Min(1)
    private Long amount;

    @ApiModelProperty("货币类型，默认 人民币:CNY, 具体参看 https://baike.baidu.com/item/ISO%204217/11018231")
    @Size(min = 1, max = 4)
    private String currency = "CNY";

    @ApiModelProperty("客户端发起支付请求时的ip地址")
    @Size(max = 16)
    private String clientIp;

    @ApiModelProperty("客户端发起支付请求时的设备")
    @Size(max = 64)
    private String device;

    @ApiModelProperty("其它参数，做扩展使用，也可用于通知回调的时候传输")
    @Size(min = 1, max = 255)
    private String extra;

    @ApiModelProperty("JSP_API 正扫 H5使用，通知回调地址")
    private String notifyUrl;

    @ApiModelProperty("h5支付使用，前端支付成功跳转地址")
    private String pickUpUrl;

    @ApiModelProperty("JS支付时使用,微信支付-用户的微信openid,支付宝支付-用户user_id")
    @Size(max = 64)
    private String payAccount;

    @ApiModelProperty("支付授权码\t如微信,支付宝,银联的付款二维码")
    private String authCode;

    @ApiModelProperty("备注")
    private String remark;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }

}
