package com.ec.primus.component.model.payment.vo.paymentorder;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @author defei
 * @data 6/23/18.
 */
@ApiModel
@Data
public class PaymentOrderCreateRespVO {

    @ApiModelProperty("支付单id")
    private String id;

    @ApiModelProperty(value = "商户ID")
    private String mchId;

    @ApiModelProperty("商户端的订单号")
    private String mchOrderNo;

    @ApiModelProperty("第三方支付需要的参数转换为的内容,扫码支付则返回二维码串，js支付则返回json字符串, App支付返回json串")
    private String paymentSdkParametersJson;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
