package com.ec.primus.component.model.payment.vo.paymentorder;

import com.ec.primus.commons.vo.PageRequestVO;
import com.ec.primus.component.model.payment.enums.PaymentStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Size;

/**
 * @author defei
 * @data 6/26/18.
 */
@ApiModel
@Data
public class PaymentOrderFindAllReqVO extends PageRequestVO {

    @ApiModelProperty("商户ID")
    @Size(min = 1, max = 32)
    private String mchId;

    @ApiModelProperty("支付渠道")
    @Size(max = 32)
    private String paymentChannel;

    @ApiModelProperty("交易类型")
    @Size(max = 32)
    private String tradeType;

    @ApiModelProperty("开始时间")
    private Long startTime;

    @ApiModelProperty("结束时间")
    private Long endTime;

    @ApiModelProperty("交易状态")
    private PaymentStatusEnum paymentStatus;
}
