package com.ec.primus.component.model.payment.vo.paymentorder;

import com.ec.primus.component.model.payment.constant.MerchantConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.Min;
import javax.validation.constraints.Size;

/**
 * @author defei
 * @data 6/23/18.
 */
@ApiModel
@Data
public class PaymentOrderRefundReqVO {

    @ApiModelProperty("支付单号")
    @Size(max = 32)
    private String paymentOrderId;

    @ApiModelProperty(value = "商户ID", required = true)
    @Size(min = 1, max = 32)
    private String mchId = MerchantConstant.DEFAULT_MERCHANT_ID;

    @ApiModelProperty("商户端的订单号")
    @Size(max = 32)
    private String mchOrderNo;

    @ApiModelProperty("退款单号,退款请求号，部分退款时必传")
    @Size(max = 32)
    private String refundNo;

    @ApiModelProperty("交易订单号")
    @Size(max = 64)
    private String tradeNo;

    @ApiModelProperty(value = "订单总金额", required = true)
    @Min(1)
    private Long totalAmount;

    @ApiModelProperty(value = "退款金额", required = true)
    @Min(1)
    private Long refundAmount;

    @ApiModelProperty(value = "退款批次号", required = true)
    @Size(min = 1, max = 64)
    private String refundBatchNo;

    @ApiModelProperty(value = "退款总笔数, 必填，即参数detail_data的值中，“#”字符出现的数量加1，最大支持1000笔（即“#”字符出现的最大数量999个）", required = true)
    @Size(min = 1, max = 32)
    private String batchNum = "1";

    @ApiModelProperty("退款原因")
    @Size(max = 80)
    private String refundReason;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
