package com.ec.primus.component.model.payment.vo.paymentorder;

import com.ec.primus.component.model.payment.enums.PaymentStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.sql.Timestamp;
import java.util.List;

/**
 * @author defei
 * @data 6/26/18.
 */
@ApiModel
@Data
public class PaymentOrderVO {

    @ApiModelProperty("支付单号")
    private Long id;

    @ApiModelProperty("商户ID")
    private String mchId;

    @ApiModelProperty("商户订单号")
    private String mchOrderNo;

    @ApiModelProperty("支付渠道名称")
    private String paymentChannelName;

    @ApiModelProperty("支付渠道")
    private String paymentChannel;

    @ApiModelProperty("交易方式名称")
    private String tradeTypeName;

    @ApiModelProperty("交易方式")
    private String tradeType;

    @ApiModelProperty("支付金额,单位分")
    private Long amount;

    @ApiModelProperty("三位货币代码,人民币:cny")
    private String currency;

    @ApiModelProperty("支付状态")
    private PaymentStatusEnum paymentStatus;

    @ApiModelProperty("客户端IP")
    private String clientIp;

    @ApiModelProperty("设备")
    private String device;

    @ApiModelProperty("订单标题")
    private String subject;

    @ApiModelProperty("订单描述信息")
    private String body;

    @ApiModelProperty("发起时额外参数")
    private String extra;

    @ApiModelProperty("支付渠道 AppId")
    private String appId;

    @ApiModelProperty("支付渠道订单号")
    private String tradeNo;

    @ApiModelProperty("退款请求号")
    private List<String> refundRequestNo;

    @ApiModelProperty("渠道支付错误码")
    private String errCode;

    @ApiModelProperty("渠道支付错误描述")
    private String errMsg;

    @ApiModelProperty("扩展参数1")
    private String param1;

    @ApiModelProperty("扩展参数2")
    private String param2;

    @ApiModelProperty("订单失效时间")
    private Timestamp expireTime;

    @ApiModelProperty("订单支付成功时间")
    private Timestamp paySuccessTime;

    @ApiModelProperty("微信，支付宝支付账号")
    private String payAccount;

    @ApiModelProperty("创建时间")
    private Timestamp createTimestamp;
}
