package com.ec.primus.component.model.payment.vo.paymentorder;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.Size;

/**
 * @author defei
 * @data 6/23/18.
 */
@ApiModel
@Data
public class PaymentStatusCheckReqVO {

    @ApiModelProperty("id")
    private String id;

    @ApiModelProperty(value = "商户ID")
    @Size(min = 1, max = 32)
    private String mchId;

    @ApiModelProperty("商户端的订单号")
    @Size(max = 64)
    private String mchOrderNo;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
