package com.ec.primus.component.model.payment.vo.paymentorder;

import com.ec.primus.component.model.payment.enums.PaymentStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.sql.Timestamp;
import java.util.List;

/**
 * @author defei
 * @data 6/23/18.
 */
@ApiModel
@Data
public class PaymentStatusCheckRespVO {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty(value = "商户ID")
    private String mchId;

    @ApiModelProperty("商户端的订单号")
    private String mchOrderNo;

    @ApiModelProperty("支付渠道AppId")
    private String appId;

    @ApiModelProperty("支付渠道")
    private String paymentChannel;

    @ApiModelProperty("交易类型")
    private String tradeType;

    @ApiModelProperty("交易金额")
    private Long amount;

    @ApiModelProperty("订单支付状态")
    private PaymentStatusEnum paymentStatus;

    @ApiModelProperty("交易完成时间")
    private Timestamp paidTimestamp;

    @ApiModelProperty("支付账号")
    private String payAccount;

    @ApiModelProperty("支付流水号")
    private String tradeNo;

    @ApiModelProperty("门店编号")
    private String depotCode;

    @ApiModelProperty("退款单列表")
    private List<String> refundRequestNo;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
