package com.ec.primus.component.model.payment.vo.tradetype;

import com.ec.primus.commons.vo.PageRequestVO;
import com.ec.primus.component.model.base.enums.CommonStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @author defei
 * @data 6/22/18.
 */
@ApiModel
@Data
public class TradeTypeConfigurationFindAllReqVO extends PageRequestVO {

    @ApiModelProperty("支付渠道")
    @Size(max = 32)
    private String paymentChannel;

    @ApiModelProperty("交易方式")
    @Size(max = 32)
    private String tradeType;

    @ApiModelProperty("商户ID")
    @Size(max = 32)
    private String mchId;

    @ApiModelProperty(value = "状态", required = true)
    @NotNull
    private CommonStatus status;

    @ApiModelProperty(value = "是否已经删除，已删除为:true", required = true)
    @NotNull
    private Boolean deleteFlag = false;
}
