package com.ec.primus.component.model.payment.vo.tradetype;

import com.ec.primus.component.model.base.enums.CommonStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @author defei
 * @data 6/22/18.
 */
@ApiModel
@Data
public class TradeTypeConfigurationUpdateReqVO {

    @ApiModelProperty(value = "支付渠道", required = true)
    @Size(min = 1, max = 32)
    private String paymentChannel;

    @ApiModelProperty(value = "交易方式", required = true)
    @Size(min = 1, max = 32)
    private String tradeType;

    @ApiModelProperty(value = "商户ID", required = true)
    @Size(min = 1, max = 32)
    private String mchId;

    @ApiModelProperty("备注")
    @Size(max = 255)
    private String remark;

    @ApiModelProperty(value = "状态", required = true)
    @NotNull
    private CommonStatus status;

    @ApiModelProperty("配置Json")
    private String configurationJson;
}
