package com.ec.primus.component.model.payment.vo.tradetype;

import com.ec.primus.component.model.base.enums.CommonStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 获取配置的交易渠道
 *
 * @author ning.zhang
 * @date 2019/11/20
 */
@ApiModel("获取配置的交易渠道")
@Data
public class TradeTypeEnableListReqVO implements Serializable {

    private static final long serialVersionUID = 6196752836367110346L;

    @ApiModelProperty(value = "商户ID", required = true)
    @NotNull
    private String mchId;

    @ApiModelProperty(value = "状态", required = true)
    @NotNull
    private CommonStatus status;
}
