package com.ec.primus.component.model.payment.vo.tradetype;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @author defei
 * @data 6/22/18.
 */
@ApiModel
@Data
public class TradeTypeUserAccountInfoQueryReqVO {

    @ApiModelProperty("支付渠道")
    @Size(min = 1, max = 32)
    private String paymentChannel;

    @ApiModelProperty("交易方式")
    @Size(min = 1, max = 32)
    private String tradeType;

    @ApiModelProperty("商户ID")
    @Size(min = 1, max = 32)
    private String mchId;

    @ApiModelProperty("用户账号")
    @NotNull
    private String account;

    @ApiModelProperty("加密后的用户账号查询密码")
    @NotNull
    private String encryptedQueryPassword;
}
