package com.ec.primus.component.model.upgrade.enums;


import com.ec.primus.commons.exception.ExceptionType;

/**
 * Created by defei on 9/22/17.
 */
public enum UpgradeExceptionEnum implements ExceptionType {

    ILLEGAL_PARAMETER(400, "参数错误:'%s'"),

    UPGRADE_TYPE_VERSION_EXIST(1000, "应用升级数据已经存在"),

    UPGRADE_VERSION_EXPIRED(1001, "应用升级版本过期，已经有更新的升级版本数据"),;

    UpgradeExceptionEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    private int code;

    private String description;

    @Override
    public int getCode() {
        return code;
    }

    @Override
    public String getDescription() {
        return description;
    }
}
