package com.ec.primus.component.model.upgrade.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

/**
 * 升级检查请求VO
 *
 * @author defei
 * @data 6/22/18.
 */
@ApiModel
@Data
public class UpgradeCheckReqVO {

    @ApiModelProperty("版本号")
    @Size(min = 5, max = 15, message = "版本号不能为空，最大长度为15位")
    @Pattern(regexp = "^\\d+\\.\\d+\\.\\d+$", message = "无效的版本，支持版本格式为\"数字.数字.数字\"")
    private String version;

    @ApiModelProperty("应用类型")
    @Size(min = 1, max = 15, message = "应用类型不为能空，最大长度为15位")
    private String type;

}
