/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.base.service;

import com.ec.primus.commons.exception.BusinessSilentException;
import com.ec.primus.commons.exception.ExceptionType;
import com.ec.primus.component.service.base.event.Executable;
import com.ec.primus.component.service.base.exception.BaseExceptions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NamedThreadLocal;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class TransactionOptDelayer {
    private static final Logger log = LoggerFactory.getLogger(TransactionOptDelayer.class);
    private static final ThreadLocal<Map<String, Stack<Executable>>> afterTransactionOpts = new NamedThreadLocal("redis\u540e\u7f6e\u64cd\u4f5cthread-local");

    public void executeAfterTransactionCommit(Executable executable) {
        if (!TransactionSynchronizationManager.isActualTransactionActive()) {
            BusinessSilentException e = new BusinessSilentException((ExceptionType)BaseExceptions.SERVER_EXCEPTION, "\u4e8b\u52a1\u540e\u7f6e\u64cd\u4f5c*\u5fc5\u987b*\u5728\u4e00\u4e2a\u6d3b\u8dc3\u7684\u4e8b\u52a1\u4e2d");
            log.error("\u4e8b\u52a1\u540e\u7f6e\u64cd\u4f5c*\u5fc5\u987b*\u5728\u4e00\u4e2a\u6d3b\u8dc3\u7684\u4e8b\u52a1\u4e2d", (Throwable)e);
            throw e;
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)AfterTransactionSynchronization.INSTANCE);
        Stack<Executable> executables = this.getExecutablesCreateIfNecessary();
        executables.push(executable);
    }

    private Stack<Executable> getExecutablesCreateIfNecessary() {
        Stack executables;
        HashMap executableMap = afterTransactionOpts.get();
        String transactionName = TransactionOptDelayer.getTransactionName();
        if (executableMap == null) {
            executableMap = Maps.newHashMap();
            afterTransactionOpts.set(executableMap);
        }
        if ((executables = (Stack)executableMap.get(transactionName)) == null) {
            executables = new Stack();
            executableMap.put(transactionName, executables);
        }
        return executables;
    }

    private static String getTransactionName() {
        String name = TransactionSynchronizationManager.getCurrentTransactionName();
        if (StringUtils.isBlank((CharSequence)name)) {
            return "default";
        }
        return name;
    }

    private static class AfterTransactionSynchronization
    extends TransactionSynchronizationAdapter {
        private static final Logger log = LoggerFactory.getLogger(AfterTransactionSynchronization.class);
        private static final AfterTransactionSynchronization INSTANCE = new AfterTransactionSynchronization();

        private AfterTransactionSynchronization() {
        }

        public void afterCompletion(int status) {
            Map map = (Map)afterTransactionOpts.get();
            if (map != null) {
                map.remove(TransactionOptDelayer.getTransactionName());
            }
        }

        public void afterCommit() {
            String transactionName;
            Map stackMap = (Map)afterTransactionOpts.get();
            Stack executables = (Stack)stackMap.get(transactionName = TransactionOptDelayer.getTransactionName());
            if (CollectionUtils.isNotEmpty((Collection)executables)) {
                while (!executables.isEmpty()) {
                    Executable executable = (Executable)executables.pop();
                    try {
                        executable.exec();
                    }
                    catch (Throwable e) {
                        log.error("\u6267\u884c\u4e8b\u52a1\u540e\u7f6e\u64cd\u4f5c\u51fa\u9519, transactionName={},msg={}", new Object[]{transactionName, e.getMessage(), e});
                    }
                }
                executables.clear();
            }
        }
    }
}

