/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.api;

import com.ec.primus.commons.vo.PageResultVO;
import com.ec.primus.component.model.base.exception.annotation.BizExceptionResponse;
import com.ec.primus.component.model.payment.enums.MerchantExceptionEnum;
import com.ec.primus.component.model.payment.enums.PaymentExceptionEnum;
import com.ec.primus.component.model.payment.vo.merchant.MerchantCreateReqVO;
import com.ec.primus.component.model.payment.vo.merchant.MerchantDisableReqVO;
import com.ec.primus.component.model.payment.vo.merchant.MerchantFindAllReqVO;
import com.ec.primus.component.model.payment.vo.merchant.MerchantGetReqVO;
import com.ec.primus.component.model.payment.vo.merchant.MerchantUpdateReqVO;
import com.ec.primus.component.model.payment.vo.merchant.MerchantVO;
import com.ec.primus.component.service.payment.api.IMerchantApi;
import com.ec.primus.component.service.payment.service.MerchantService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u6237\u63a5\u53e3"})
@RestController
@RequestMapping(value={"soa/merchantApi"})
public class MerchantApiController
implements IMerchantApi {
    private static final Logger log = LoggerFactory.getLogger(MerchantApiController.class);
    private final MerchantService merchantService;

    @Autowired
    public MerchantApiController(MerchantService merchantService) {
        this.merchantService = merchantService;
    }

    @Override
    @ApiOperation(value="\u521b\u5efa\u5546\u6237", notes="@developer \u9093\u5fb7\u98de<br/>\u521b\u5efa\u5546\u6237")
    @BizExceptionResponse(value={PaymentExceptionEnum.class})
    @PostMapping(value={"create"})
    public MerchantVO create(@RequestBody MerchantCreateReqVO reqVO) {
        return this.merchantService.create(reqVO);
    }

    @Override
    @ApiOperation(value="\u83b7\u53d6\u5546\u6237", notes="@developer \u9093\u5fb7\u98de<br/>\u83b7\u53d6\u5546\u6237")
    @BizExceptionResponse(value={PaymentExceptionEnum.class, MerchantExceptionEnum.class})
    @PostMapping(value={"get"})
    public MerchantVO get(@RequestBody MerchantGetReqVO reqVO) {
        return this.merchantService.get(reqVO.getId());
    }

    @Override
    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u6240\u6709\u5546\u6237", notes="@developer \u9093\u5fb7\u98de<br/>\u5206\u9875\u83b7\u53d6\u6240\u6709\u5546\u6237", response=MerchantVO.class, responseContainer="SpringPageVO")
    @BizExceptionResponse(value={PaymentExceptionEnum.class})
    @PostMapping(value={"findAll"})
    public PageResultVO<MerchantVO> findAll(@RequestBody MerchantFindAllReqVO reqVO) {
        return this.merchantService.findAll(reqVO);
    }

    @Override
    @ApiOperation(value="\u66f4\u65b0\u5546\u6237", notes="@developer \u9093\u5fb7\u98de<br/>\u66f4\u65b0\u5546\u6237")
    @BizExceptionResponse(value={PaymentExceptionEnum.class, MerchantExceptionEnum.class})
    @PostMapping(value={"update"})
    public MerchantVO update(@RequestBody MerchantUpdateReqVO reqVO) {
        return this.merchantService.update(reqVO);
    }

    @Override
    @ApiOperation(value="\u7981\u7528\u5546\u6237", notes="@developer \u9093\u5fb7\u98de<br/>\u7981\u7528\u5546\u6237")
    @BizExceptionResponse(value={PaymentExceptionEnum.class, MerchantExceptionEnum.class})
    @PostMapping(value={"disable"})
    public void disable(@RequestBody MerchantDisableReqVO reqVO) {
        this.merchantService.disable(reqVO);
    }
}

