/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.api;

import com.ec.primus.commons.vo.PageResultVO;
import com.ec.primus.component.model.base.exception.BizBusinessException;
import com.ec.primus.component.model.base.exception.annotation.BizExceptionResponse;
import com.ec.primus.component.model.payment.enums.PaymentExceptionEnum;
import com.ec.primus.component.model.payment.enums.PaymentNotifyTypeEnum;
import com.ec.primus.component.model.payment.enums.PaymentOrderExceptionEnum;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentNotifyReqVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderCloseReqVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderCreateReqVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderCreateRespVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderFindAllReqVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderGetReqVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderRefundReqVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderRefundRespVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderRefundStatusCheckReqVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderRefundStatusCheckRespVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentStatusCheckReqVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentStatusCheckRespVO;
import com.ec.primus.component.model.payment.vo.paymentorder.RefundNotifyReqVO;
import com.ec.primus.component.service.payment.api.IPaymentOrderApi;
import com.ec.primus.component.service.payment.exception.PaymentOrderIsExpiredException;
import com.ec.primus.component.service.payment.exception.PaymentOrderIsPaidException;
import com.ec.primus.component.service.payment.service.PaymentOrderService;
import com.ec.primus.component.service.payment.service.PaymentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u652f\u4ed8\u5355\u63a5\u53e3"})
@RestController
@RequestMapping(value={"soa/paymentOrderApi"})
public class PaymentOrderApiController
implements IPaymentOrderApi {
    private static final Logger log = LoggerFactory.getLogger(PaymentOrderApiController.class);
    private final PaymentService paymentService;
    private final PaymentOrderService paymentOrderService;

    @Autowired
    public PaymentOrderApiController(PaymentService paymentService, PaymentOrderService paymentOrderService) {
        this.paymentService = paymentService;
        this.paymentOrderService = paymentOrderService;
    }

    @Override
    @ApiOperation(value="\u67e5\u8be2\u652f\u4ed8\u5355", notes="@developer \u9093\u5fb7\u98de<br/>\u67e5\u8be2\u652f\u4ed8\u5355")
    @BizExceptionResponse(value={PaymentExceptionEnum.class, PaymentOrderExceptionEnum.class})
    @PostMapping(value={"findPaymentOrder"})
    public PaymentOrderVO findPaymentOrder(@RequestBody PaymentOrderGetReqVO reqVO) {
        return this.paymentOrderService.findPaymentOrder(reqVO);
    }

    @Override
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u652f\u4ed8\u5355", notes="@developer \u9093\u5fb7\u98de<br/>\u5206\u9875\u67e5\u8be2\u652f\u4ed8\u5355", response=PaymentOrderVO.class, responseContainer="SpringPageVO")
    @BizExceptionResponse(value={PaymentExceptionEnum.class})
    @PostMapping(value={"findPaymentOrders"})
    public PageResultVO<PaymentOrderVO> findPaymentOrders(@RequestBody PaymentOrderFindAllReqVO reqVO) {
        return this.paymentOrderService.findPaymentOrders(reqVO);
    }

    @Override
    @ApiOperation(value="\u521b\u5efa\u652f\u4ed8\u5355", notes="@developer \u9093\u5fb7\u98de<br/>\u521b\u5efa\u652f\u4ed8\u5355")
    @BizExceptionResponse(value={PaymentExceptionEnum.class, PaymentOrderExceptionEnum.class})
    @PostMapping(value={"create"})
    public PaymentOrderCreateRespVO create(@RequestBody PaymentOrderCreateReqVO reqVO) throws PaymentOrderIsPaidException, PaymentOrderIsExpiredException, BizBusinessException {
        return this.paymentService.createPaymentOrder(reqVO);
    }

    @Override
    @ApiOperation(value="\u68c0\u67e5\u652f\u4ed8\u5355\u4ed8\u6b3e\u72b6\u6001", notes="@developer \u9093\u5fb7\u98de<br/>\u68c0\u67e5\u652f\u4ed8\u5355\u4ed8\u6b3e\u72b6\u6001")
    @BizExceptionResponse(value={PaymentExceptionEnum.class, PaymentOrderExceptionEnum.class})
    @PostMapping(value={"checkPaymentStatus"})
    public PaymentStatusCheckRespVO checkPaymentStatus(@RequestBody PaymentStatusCheckReqVO reqVO) throws BizBusinessException {
        return this.paymentService.checkPaymentStatus(reqVO.getId(), reqVO.getMchId(), reqVO.getMchOrderNo());
    }

    @Override
    @ApiOperation(value="\u9000\u6b3e", notes="@developer \u9093\u5fb7\u98de<br/>\u9000\u6b3e")
    @BizExceptionResponse(value={PaymentExceptionEnum.class, PaymentOrderExceptionEnum.class})
    @PostMapping(value={"refund"})
    public PaymentOrderRefundRespVO refund(@RequestBody PaymentOrderRefundReqVO reqVO) throws BizBusinessException {
        return this.paymentService.refund(reqVO);
    }

    @Override
    @ApiOperation(value="\u68c0\u67e5\u652f\u4ed8\u5355\u9000\u6b3e\u72b6\u6001", notes="@developer \u9093\u5fb7\u98de<br/>\u68c0\u67e5\u652f\u4ed8\u5355\u9000\u6b3e\u72b6\u6001")
    @BizExceptionResponse(value={PaymentExceptionEnum.class, PaymentOrderExceptionEnum.class})
    @PostMapping(value={"checkRefundStatus"})
    public PaymentOrderRefundStatusCheckRespVO checkRefundStatus(@RequestBody PaymentOrderRefundStatusCheckReqVO reqVO) throws BizBusinessException {
        return this.paymentService.checkRefundStatus(reqVO);
    }

    @Override
    @ApiOperation(value="\u5173\u95ed\u652f\u4ed8\u5355", notes="@developer \u9093\u5fb7\u98de<br/>\u5173\u95ed\u652f\u4ed8\u5355")
    @BizExceptionResponse(value={PaymentExceptionEnum.class, PaymentOrderExceptionEnum.class})
    @PostMapping(value={"close"})
    public void close(@RequestBody PaymentOrderCloseReqVO reqVO) throws PaymentOrderIsPaidException, BizBusinessException {
        this.paymentService.close(reqVO);
    }

    @Override
    @ApiOperation(value="\u5904\u7406\u7b2c\u4e09\u65b9\u652f\u4ed8\u5355\u652f\u4ed8\u7ed3\u679c\u901a\u77e5", notes="@developer \u9093\u5fb7\u98de<br/>\u5904\u7406\u7b2c\u4e09\u65b9\u652f\u4ed8\u5355\u652f\u4ed8\u7ed3\u679c\u901a\u77e5")
    @BizExceptionResponse(value={PaymentExceptionEnum.class})
    @PostMapping(value={"handlePaymentNotify"})
    public void handlePaymentNotify(@RequestBody PaymentNotifyReqVO reqVO) throws BizBusinessException {
        this.paymentService.handleNotify(PaymentNotifyTypeEnum.PAY, reqVO.getPaymentChannel(), reqVO.getNotifyData());
    }

    @Override
    @ApiOperation(value="\u5904\u7406\u7b2c\u4e09\u65b9\u652f\u4ed8\u5355\u9000\u6b3e\u7ed3\u679c\u901a\u77e5", notes="@developer \u9093\u5fb7\u98de<br/>\u5904\u7406\u7b2c\u4e09\u65b9\u652f\u4ed8\u5355\u9000\u6b3e\u7ed3\u679c\u901a\u77e5")
    @BizExceptionResponse(value={PaymentExceptionEnum.class})
    @PostMapping(value={"handleRefundNotify"})
    public void handleRefundNotify(@RequestBody RefundNotifyReqVO reqVO) throws BizBusinessException {
        this.paymentService.handleNotify(PaymentNotifyTypeEnum.REFUND, reqVO.getPaymentChannel(), reqVO.getNotifyData());
    }
}

