/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.api;

import com.ec.primus.commons.vo.PageResultVO;
import com.ec.primus.component.model.base.exception.BizBusinessException;
import com.ec.primus.component.model.base.exception.annotation.BizExceptionResponse;
import com.ec.primus.component.model.payment.enums.PaymentExceptionEnum;
import com.ec.primus.component.model.payment.enums.TradeTypeExceptionEnum;
import com.ec.primus.component.model.payment.vo.ITradeType;
import com.ec.primus.component.model.payment.vo.TradeTypeVO;
import com.ec.primus.component.model.payment.vo.tradetype.TradeTypeConfigurationFindAllByMerchantReqVO;
import com.ec.primus.component.model.payment.vo.tradetype.TradeTypeConfigurationFindAllReqVO;
import com.ec.primus.component.model.payment.vo.tradetype.TradeTypeConfigurationGetReqVO;
import com.ec.primus.component.model.payment.vo.tradetype.TradeTypeConfigurationUpdateReqVO;
import com.ec.primus.component.model.payment.vo.tradetype.TradeTypeConfigurationVO;
import com.ec.primus.component.model.payment.vo.tradetype.TradeTypeEnableListReqVO;
import com.ec.primus.component.model.payment.vo.tradetype.TradeTypeUserAccountInfoQueryReqVO;
import com.ec.primus.component.model.payment.vo.tradetype.TradeTypeUserAccountInfoQueryRespVO;
import com.ec.primus.component.service.payment.api.ITradeTypeApi;
import com.ec.primus.component.service.payment.service.TradeTypeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4ea4\u6613\u7c7b\u578b\u63a5\u53e3"})
@RestController
@RequestMapping(value={"soa/tradeTypeApi"})
public class TradeTypeApiController
implements ITradeTypeApi {
    private static final Logger log = LoggerFactory.getLogger(TradeTypeApiController.class);
    private final TradeTypeService tradeTypeService;

    @Autowired
    public TradeTypeApiController(TradeTypeService tradeTypeService) {
        this.tradeTypeService = tradeTypeService;
    }

    @Override
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u53ef\u7528\u7684\u4ea4\u6613\u7c7b\u578b", notes="@developer \u9093\u5fb7\u98de<br/>\u83b7\u53d6\u6240\u6709\u53ef\u7528\u7684\u4ea4\u6613\u7c7b\u578b", response=TradeTypeVO.class, responseContainer="List")
    @BizExceptionResponse(value={PaymentExceptionEnum.class})
    @PostMapping(value={"listSupportedITradeTypes"})
    public Collection<ITradeType> listSupportedTradeTypes() {
        return this.tradeTypeService.listSupportedTradeTypes();
    }

    @Override
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u53ef\u7528\u5e76\u914d\u7f6e\u7684\u4ea4\u6613\u7c7b\u578b", notes="@developer \u5f20\u5b81<br/>\u83b7\u53d6\u6240\u6709\u53ef\u7528\u5e76\u914d\u7f6e\u7684\u4ea4\u6613\u7c7b\u578b", response=TradeTypeVO.class, responseContainer="List")
    @BizExceptionResponse(value={PaymentExceptionEnum.class})
    @PostMapping(value={"listSupportedAndEnableITradeTypes"})
    public Collection<ITradeType> listSupportedAndEnableITradeTypes(@RequestBody TradeTypeEnableListReqVO reqVO) {
        return this.tradeTypeService.listSupportedAndEnableITradeTypes(reqVO);
    }

    @Override
    @ApiOperation(value="\u66f4\u65b0\u5546\u6237\u4ea4\u6613\u914d\u7f6e\u6587\u4ef6", notes="@developer \u9093\u5fb7\u98de<br/>\u66f4\u65b0\u5546\u6237\u4ea4\u6613\u914d\u7f6e\u6587\u4ef6")
    @BizExceptionResponse(value={PaymentExceptionEnum.class})
    @PostMapping(value={"updateMerchantTradeTypeConfiguration"})
    public TradeTypeConfigurationVO updateMerchantTradeTypeConfiguration(@RequestBody TradeTypeConfigurationUpdateReqVO reqVO) {
        return this.tradeTypeService.updateMerchantTradeTypeConfiguration(reqVO);
    }

    @Override
    @ApiOperation(value="\u83b7\u53d6\u5546\u6237\u4ea4\u6613\u914d\u7f6e\u6587\u4ef6", notes="@developer \u9093\u5fb7\u98de<br/>\u83b7\u53d6\u5546\u6237\u4ea4\u6613\u914d\u7f6e\u6587\u4ef6")
    @BizExceptionResponse(value={PaymentExceptionEnum.class, TradeTypeExceptionEnum.class})
    @PostMapping(value={"getTradeTypeConfiguration"})
    public TradeTypeConfigurationVO getTradeTypeConfiguration(@RequestBody TradeTypeConfigurationGetReqVO reqVO) throws BizBusinessException {
        return this.tradeTypeService.getTradeTypeConfiguration(reqVO);
    }

    @Override
    @ApiOperation(value="\u83b7\u53d6\u5546\u6237\u6240\u6709\u4ea4\u6613\u914d\u7f6e\u6587\u4ef6", notes="@developer \u9093\u5fb7\u98de<br/>\u83b7\u53d6\u5546\u6237\u6240\u6709\u4ea4\u6613\u914d\u7f6e\u6587\u4ef6", response=TradeTypeConfigurationVO.class, responseContainer="List")
    @BizExceptionResponse(value={PaymentExceptionEnum.class})
    @PostMapping(value={"findAllTradeTypeConfigurationsByMerchantId"})
    public List<TradeTypeConfigurationVO> findAllTradeTypeConfigurationsByMerchantId(@RequestBody TradeTypeConfigurationFindAllByMerchantReqVO reqVO) {
        return this.tradeTypeService.findAllTradeTypeConfigurationsByMerchantId(reqVO);
    }

    @Override
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u4ea4\u6613\u914d\u7f6e\u6587\u4ef6", notes="@developer \u9093\u5fb7\u98de<br/>\u83b7\u53d6\u6240\u6709\u7684\u4ea4\u6613\u914d\u7f6e\u6587\u4ef6", response=TradeTypeConfigurationVO.class, responseContainer="SpringPageVO")
    @BizExceptionResponse(value={PaymentExceptionEnum.class})
    @PostMapping(value={"findAllTradeTypeConfigurations"})
    public PageResultVO<TradeTypeConfigurationVO> findAllTradeTypeConfigurations(@RequestBody TradeTypeConfigurationFindAllReqVO reqVO) {
        return this.tradeTypeService.findAllTradeTypeConfigurations(reqVO);
    }

    @Override
    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u652f\u4ed8\u6e20\u9053\u7528\u6237\u8d26\u6237\u60c5\u51b5", notes="@developer \u9093\u5fb7\u98de<br/>\u67e5\u8be2\u5f53\u524d\u652f\u4ed8\u6e20\u9053\u7528\u6237\u8d26\u6237\u60c5\u51b5")
    @BizExceptionResponse(value={PaymentExceptionEnum.class, TradeTypeExceptionEnum.class})
    @PostMapping(value={"tradeTypeUserAccountInfoQuery"})
    public TradeTypeUserAccountInfoQueryRespVO tradeTypeUserAccountInfoQuery(@RequestBody TradeTypeUserAccountInfoQueryReqVO reqVO) {
        return this.tradeTypeService.tradeTypeUserAccountInfoQuery(reqVO);
    }
}

