/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.config;

import com.ec.primus.component.service.payment.annotation.EnablePayment;
import com.ec.primus.component.service.payment.mock.MockPaymentServiceComponent;
import com.ec.primus.component.service.payment.service.PaymentChannelRegister;
import com.ec.primus.component.service.payment.service.TradeTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@ConditionalOnBean(annotation={EnablePayment.class})
@Configuration
@EntityScan(basePackages={"com.ec.primus.component.service.payment.dao.po"})
@EnableJpaRepositories(value={"com.ec.primus.component.service.payment.dao.repository"})
@ComponentScan(basePackages={"com.ec.primus.component.service.payment.api", "com.ec.primus.component.service.payment.service", "com.ec.primus.component.service.base.service"})
public class PaymentAutoConfiguration {
    @Value(value="${primus.mock.payment.enable:false}")
    private String currentEnv;

    @Bean
    public MockPaymentServiceComponent getMockPaymentServiceComponent(@Autowired PaymentChannelRegister paymentChannelRegister, @Autowired TradeTypeService tradeTypeService) {
        MockPaymentServiceComponent mockPaymentServiceComponent = new MockPaymentServiceComponent(tradeTypeService);
        if (Boolean.TRUE.toString().equals(this.currentEnv)) {
            mockPaymentServiceComponent.enable(paymentChannelRegister);
        }
        return mockPaymentServiceComponent;
    }
}

