/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.dao.po;

import com.ec.primus.component.model.payment.enums.PaymentStatusEnum;
import com.ec.primus.jpa.converter.ListStringConverter;
import com.ec.primus.jpa.po.BaseEntity;
import java.sql.Timestamp;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table(name="payment_order", indexes={@Index(columnList="mchId"), @Index(columnList="mchId, mchOrderNo"), @Index(columnList="paymentChannel"), @Index(columnList="paymentStatus")})
public class PaymentOrder
extends BaseEntity {
    private static final long serialVersionUID = 7076411787442167785L;
    @Column(length=32)
    @NotNull
    private String mchId;
    @Column(length=64)
    @NotNull
    private String mchOrderNo;
    @Column(length=32)
    @Size(min=1, max=32)
    private String paymentChannel;
    @Column(length=32)
    @Size(min=1, max=32)
    private String tradeType;
    @Min(value=1L)
    private Long amount;
    @Column(length=4)
    @Size(min=1, max=4)
    private String currency;
    @Column
    @NotNull
    @Convert(converter=PaymentStatusEnum.Converter.class)
    private PaymentStatusEnum paymentStatus = PaymentStatusEnum.CREATE_PAYMENT;
    @Column(length=100)
    @Size(max=100)
    private String clientIp;
    @Column(length=64)
    @Size(max=64)
    private String device;
    @Column(length=64)
    @Size(min=1, max=64)
    private String subject;
    @Column(length=128)
    @Size(min=1, max=128)
    private String body;
    private String extra;
    @Column(length=64)
    @Size(max=64)
    private String appId;
    @Column(length=64)
    @Size(max=64)
    private String tradeNo;
    @Convert(converter=ListStringConverter.class)
    private List<String> refundRequestNo;
    @Column(length=32)
    private String errCode;
    @Column(length=64)
    private String errMsg;
    @Column(length=64)
    private String param1;
    private String param2;
    private String notifyUrl;
    private Byte notifyCount;
    private Timestamp lastNotifyTime;
    @NotNull
    private Timestamp expireTime;
    private Timestamp paySuccessTime;
    @Column(length=64)
    @Size(max=64)
    private String payAccount;

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this), (ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    public Boolean isExpired() {
        return this.expireTime == null || this.expireTime.getTime() < System.currentTimeMillis();
    }

    public String getMchId() {
        return this.mchId;
    }

    public String getMchOrderNo() {
        return this.mchOrderNo;
    }

    public String getPaymentChannel() {
        return this.paymentChannel;
    }

    public String getTradeType() {
        return this.tradeType;
    }

    public Long getAmount() {
        return this.amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public PaymentStatusEnum getPaymentStatus() {
        return this.paymentStatus;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getDevice() {
        return this.device;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    public String getExtra() {
        return this.extra;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getTradeNo() {
        return this.tradeNo;
    }

    public List<String> getRefundRequestNo() {
        return this.refundRequestNo;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public String getParam1() {
        return this.param1;
    }

    public String getParam2() {
        return this.param2;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public Byte getNotifyCount() {
        return this.notifyCount;
    }

    public Timestamp getLastNotifyTime() {
        return this.lastNotifyTime;
    }

    public Timestamp getExpireTime() {
        return this.expireTime;
    }

    public Timestamp getPaySuccessTime() {
        return this.paySuccessTime;
    }

    public String getPayAccount() {
        return this.payAccount;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public void setMchOrderNo(String mchOrderNo) {
        this.mchOrderNo = mchOrderNo;
    }

    public void setPaymentChannel(String paymentChannel) {
        this.paymentChannel = paymentChannel;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setPaymentStatus(PaymentStatusEnum paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public void setRefundRequestNo(List<String> refundRequestNo) {
        this.refundRequestNo = refundRequestNo;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public void setParam1(String param1) {
        this.param1 = param1;
    }

    public void setParam2(String param2) {
        this.param2 = param2;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public void setNotifyCount(Byte notifyCount) {
        this.notifyCount = notifyCount;
    }

    public void setLastNotifyTime(Timestamp lastNotifyTime) {
        this.lastNotifyTime = lastNotifyTime;
    }

    public void setExpireTime(Timestamp expireTime) {
        this.expireTime = expireTime;
    }

    public void setPaySuccessTime(Timestamp paySuccessTime) {
        this.paySuccessTime = paySuccessTime;
    }

    public void setPayAccount(String payAccount) {
        this.payAccount = payAccount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentOrder)) {
            return false;
        }
        PaymentOrder other = (PaymentOrder)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$mchId = this.getMchId();
        String other$mchId = other.getMchId();
        if (this$mchId == null ? other$mchId != null : !this$mchId.equals(other$mchId)) {
            return false;
        }
        String this$mchOrderNo = this.getMchOrderNo();
        String other$mchOrderNo = other.getMchOrderNo();
        if (this$mchOrderNo == null ? other$mchOrderNo != null : !this$mchOrderNo.equals(other$mchOrderNo)) {
            return false;
        }
        String this$paymentChannel = this.getPaymentChannel();
        String other$paymentChannel = other.getPaymentChannel();
        if (this$paymentChannel == null ? other$paymentChannel != null : !this$paymentChannel.equals(other$paymentChannel)) {
            return false;
        }
        String this$tradeType = this.getTradeType();
        String other$tradeType = other.getTradeType();
        if (this$tradeType == null ? other$tradeType != null : !this$tradeType.equals(other$tradeType)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        PaymentStatusEnum this$paymentStatus = this.getPaymentStatus();
        PaymentStatusEnum other$paymentStatus = other.getPaymentStatus();
        if (this$paymentStatus == null ? other$paymentStatus != null : !this$paymentStatus.equals(other$paymentStatus)) {
            return false;
        }
        String this$clientIp = this.getClientIp();
        String other$clientIp = other.getClientIp();
        if (this$clientIp == null ? other$clientIp != null : !this$clientIp.equals(other$clientIp)) {
            return false;
        }
        String this$device = this.getDevice();
        String other$device = other.getDevice();
        if (this$device == null ? other$device != null : !this$device.equals(other$device)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        String this$extra = this.getExtra();
        String other$extra = other.getExtra();
        if (this$extra == null ? other$extra != null : !this$extra.equals(other$extra)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$tradeNo = this.getTradeNo();
        String other$tradeNo = other.getTradeNo();
        if (this$tradeNo == null ? other$tradeNo != null : !this$tradeNo.equals(other$tradeNo)) {
            return false;
        }
        List<String> this$refundRequestNo = this.getRefundRequestNo();
        List<String> other$refundRequestNo = other.getRefundRequestNo();
        if (this$refundRequestNo == null ? other$refundRequestNo != null : !((Object)this$refundRequestNo).equals(other$refundRequestNo)) {
            return false;
        }
        String this$errCode = this.getErrCode();
        String other$errCode = other.getErrCode();
        if (this$errCode == null ? other$errCode != null : !this$errCode.equals(other$errCode)) {
            return false;
        }
        String this$errMsg = this.getErrMsg();
        String other$errMsg = other.getErrMsg();
        if (this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg)) {
            return false;
        }
        String this$param1 = this.getParam1();
        String other$param1 = other.getParam1();
        if (this$param1 == null ? other$param1 != null : !this$param1.equals(other$param1)) {
            return false;
        }
        String this$param2 = this.getParam2();
        String other$param2 = other.getParam2();
        if (this$param2 == null ? other$param2 != null : !this$param2.equals(other$param2)) {
            return false;
        }
        String this$notifyUrl = this.getNotifyUrl();
        String other$notifyUrl = other.getNotifyUrl();
        if (this$notifyUrl == null ? other$notifyUrl != null : !this$notifyUrl.equals(other$notifyUrl)) {
            return false;
        }
        Byte this$notifyCount = this.getNotifyCount();
        Byte other$notifyCount = other.getNotifyCount();
        if (this$notifyCount == null ? other$notifyCount != null : !((Object)this$notifyCount).equals(other$notifyCount)) {
            return false;
        }
        Timestamp this$lastNotifyTime = this.getLastNotifyTime();
        Timestamp other$lastNotifyTime = other.getLastNotifyTime();
        if (this$lastNotifyTime == null ? other$lastNotifyTime != null : !((Object)this$lastNotifyTime).equals(other$lastNotifyTime)) {
            return false;
        }
        Timestamp this$expireTime = this.getExpireTime();
        Timestamp other$expireTime = other.getExpireTime();
        if (this$expireTime == null ? other$expireTime != null : !((Object)this$expireTime).equals(other$expireTime)) {
            return false;
        }
        Timestamp this$paySuccessTime = this.getPaySuccessTime();
        Timestamp other$paySuccessTime = other.getPaySuccessTime();
        if (this$paySuccessTime == null ? other$paySuccessTime != null : !((Object)this$paySuccessTime).equals(other$paySuccessTime)) {
            return false;
        }
        String this$payAccount = this.getPayAccount();
        String other$payAccount = other.getPayAccount();
        return !(this$payAccount == null ? other$payAccount != null : !this$payAccount.equals(other$payAccount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaymentOrder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $mchId = this.getMchId();
        result = result * 59 + ($mchId == null ? 43 : $mchId.hashCode());
        String $mchOrderNo = this.getMchOrderNo();
        result = result * 59 + ($mchOrderNo == null ? 43 : $mchOrderNo.hashCode());
        String $paymentChannel = this.getPaymentChannel();
        result = result * 59 + ($paymentChannel == null ? 43 : $paymentChannel.hashCode());
        String $tradeType = this.getTradeType();
        result = result * 59 + ($tradeType == null ? 43 : $tradeType.hashCode());
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        PaymentStatusEnum $paymentStatus = this.getPaymentStatus();
        result = result * 59 + ($paymentStatus == null ? 43 : $paymentStatus.hashCode());
        String $clientIp = this.getClientIp();
        result = result * 59 + ($clientIp == null ? 43 : $clientIp.hashCode());
        String $device = this.getDevice();
        result = result * 59 + ($device == null ? 43 : $device.hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        String $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : $extra.hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $tradeNo = this.getTradeNo();
        result = result * 59 + ($tradeNo == null ? 43 : $tradeNo.hashCode());
        List<String> $refundRequestNo = this.getRefundRequestNo();
        result = result * 59 + ($refundRequestNo == null ? 43 : ((Object)$refundRequestNo).hashCode());
        String $errCode = this.getErrCode();
        result = result * 59 + ($errCode == null ? 43 : $errCode.hashCode());
        String $errMsg = this.getErrMsg();
        result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
        String $param1 = this.getParam1();
        result = result * 59 + ($param1 == null ? 43 : $param1.hashCode());
        String $param2 = this.getParam2();
        result = result * 59 + ($param2 == null ? 43 : $param2.hashCode());
        String $notifyUrl = this.getNotifyUrl();
        result = result * 59 + ($notifyUrl == null ? 43 : $notifyUrl.hashCode());
        Byte $notifyCount = this.getNotifyCount();
        result = result * 59 + ($notifyCount == null ? 43 : ((Object)$notifyCount).hashCode());
        Timestamp $lastNotifyTime = this.getLastNotifyTime();
        result = result * 59 + ($lastNotifyTime == null ? 43 : ((Object)$lastNotifyTime).hashCode());
        Timestamp $expireTime = this.getExpireTime();
        result = result * 59 + ($expireTime == null ? 43 : ((Object)$expireTime).hashCode());
        Timestamp $paySuccessTime = this.getPaySuccessTime();
        result = result * 59 + ($paySuccessTime == null ? 43 : ((Object)$paySuccessTime).hashCode());
        String $payAccount = this.getPayAccount();
        result = result * 59 + ($payAccount == null ? 43 : $payAccount.hashCode());
        return result;
    }
}

