/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.mock;

import com.ec.primus.commons.utils.JsonUtils;
import com.ec.primus.component.model.payment.enums.PaymentScene;
import com.ec.primus.component.model.payment.service.IPaymentServiceComponent;
import com.ec.primus.component.model.payment.vo.IPaymentChannel;
import com.ec.primus.component.model.payment.vo.ITradeType;
import com.ec.primus.component.model.payment.vo.PaymentChannelRegisterVO;
import com.ec.primus.component.model.payment.vo.PaymentChannelVO;
import com.ec.primus.component.model.payment.vo.TradeTypeVO;
import com.ec.primus.component.model.payment.vo.paymentorder.CommonPaidRespVo;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderCreateReqVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderRefundReqVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderRefundRespVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderRefundStatusCheckRespVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentOrderRefundStatusVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentPayNotifyParseResultVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentPayNotifyValidateResultVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentRefundNotifyParseResultVO;
import com.ec.primus.component.model.payment.vo.paymentorder.PaymentRefundNotifyValidateResultVO;
import com.ec.primus.component.model.payment.vo.tradetype.TradeTypeConfigurationUpdateReqVO;
import com.ec.primus.component.service.payment.service.PaymentChannelRegister;
import com.ec.primus.component.service.payment.service.TradeTypeService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class MockPaymentServiceComponent
implements IPaymentServiceComponent {
    private final TradeTypeService tradeTypeService;

    public MockPaymentServiceComponent(TradeTypeService tradeTypeService) {
        this.tradeTypeService = tradeTypeService;
    }

    public void enable(PaymentChannelRegister paymentChannelRegister) {
        PaymentChannelRegisterVO reqVO = new PaymentChannelRegisterVO();
        PaymentChannelVO paymentChannel = new PaymentChannelVO("MockPaymentChannel", "\u6a21\u62df\u652f\u4ed8\u6e20\u9053", "\u53ea\u662f\u4e3a\u4e86\u6d4b\u8bd5");
        TradeTypeVO appTradeType = new TradeTypeVO(paymentChannel, "MockAppTradeType", PaymentScene.APP, "\u6a21\u62df\u652f\u4ed8\u65b9\u5f0f", "\u53ea\u662f\u4e3a\u4e86\u6d4b\u8bd5", "{}");
        TradeTypeVO webTradeType = new TradeTypeVO(paymentChannel, "MockWebTradeType", PaymentScene.WEB, "\u6a21\u62df\u652f\u4ed8\u65b9\u5f0f", "\u53ea\u662f\u4e3a\u4e86\u6d4b\u8bd5", "{}");
        ArrayList tradeTypes = Lists.newArrayList((Object[])new ITradeType[]{appTradeType, webTradeType});
        reqVO.setPaymentChannel((IPaymentChannel)paymentChannel);
        reqVO.setTradeTypes((Collection)tradeTypes);
        reqVO.setPaymentServiceComponent((IPaymentServiceComponent)this);
        paymentChannelRegister.register(reqVO);
        TradeTypeConfigurationUpdateReqVO merchantTradeTypeConfigurationReqVO = new TradeTypeConfigurationUpdateReqVO();
        merchantTradeTypeConfigurationReqVO.setPaymentChannel(paymentChannel.getIdentity());
        merchantTradeTypeConfigurationReqVO.setTradeType(appTradeType.getIdentity());
        merchantTradeTypeConfigurationReqVO.setConfigurationJson(appTradeType.getConfigurationJsonDemo());
        merchantTradeTypeConfigurationReqVO.setMchId("DEFAULT_MERCHANT");
        this.tradeTypeService.updateMerchantTradeTypeConfiguration(merchantTradeTypeConfigurationReqVO);
        merchantTradeTypeConfigurationReqVO = new TradeTypeConfigurationUpdateReqVO();
        merchantTradeTypeConfigurationReqVO.setPaymentChannel(paymentChannel.getIdentity());
        merchantTradeTypeConfigurationReqVO.setTradeType(webTradeType.getIdentity());
        merchantTradeTypeConfigurationReqVO.setConfigurationJson(webTradeType.getConfigurationJsonDemo());
        merchantTradeTypeConfigurationReqVO.setMchId("DEFAULT_MERCHANT");
        this.tradeTypeService.updateMerchantTradeTypeConfiguration(merchantTradeTypeConfigurationReqVO);
    }

    public Object createPayment(String tradeTypeConfigurationJson, PaymentOrderCreateReqVO reqVO) {
        HashMap mockResult = Maps.newHashMap();
        mockResult.put("tradeNo", "MockPay" + System.currentTimeMillis());
        return JsonUtils.obj2Json((Object)mockResult);
    }

    public CommonPaidRespVo isPad(String configJson, String tradeNo, String mchOrderNo) {
        CommonPaidRespVo mockResult = new CommonPaidRespVo();
        mockResult.setTradeNo("MockPay" + mchOrderNo.hashCode());
        mockResult.setPaidTime(new Date());
        mockResult.setPaid(Boolean.valueOf(mchOrderNo.hashCode() % 2 == 0));
        mockResult.setPayAccount("mocker");
        return mockResult;
    }

    public PaymentOrderRefundRespVO refund(String configurationJson, PaymentOrderRefundReqVO reqVO) {
        PaymentOrderRefundRespVO mockResult = new PaymentOrderRefundRespVO();
        mockResult.setRefundApplySuccess(Boolean.valueOf(true));
        mockResult.setOutRefundNo(reqVO.getRefundNo());
        mockResult.setNeedManualCheck(Boolean.valueOf(false));
        mockResult.setRefundTradeNo("MockRefund" + reqVO.getMchOrderNo().hashCode());
        return mockResult;
    }

    public PaymentOrderRefundStatusCheckRespVO refundQuery(String configurationJson, String mchOrderNo, List<String> refundRequestNos) {
        PaymentOrderRefundStatusCheckRespVO mockResult = new PaymentOrderRefundStatusCheckRespVO();
        mockResult.setMchOrderNo(mchOrderNo);
        ArrayList paymentOrderRefundStatusVOs = Lists.newArrayList();
        for (String refundRequestNo : refundRequestNos) {
            PaymentOrderRefundStatusVO paymentOrderRefundStatusVO = new PaymentOrderRefundStatusVO();
            paymentOrderRefundStatusVO.setMchRefundNo(refundRequestNo);
            paymentOrderRefundStatusVO.setRefundTradNo("MockRefund" + refundRequestNo.hashCode());
            paymentOrderRefundStatusVO.setRefundApplySuccess(Boolean.valueOf(true));
            paymentOrderRefundStatusVO.setRefunding(Boolean.valueOf(true));
            paymentOrderRefundStatusVO.setRefundAmount(Long.valueOf(Math.abs(refundRequestNo.hashCode() % 47)));
            paymentOrderRefundStatusVOs.add(paymentOrderRefundStatusVO);
        }
        mockResult.setPaymentOrderRefundStatusVOs((List)paymentOrderRefundStatusVOs);
        return mockResult;
    }

    public PaymentPayNotifyParseResultVO parsePayNotify(String notifyData) {
        PaymentPayNotifyParseResultVO mockResult = new PaymentPayNotifyParseResultVO();
        mockResult.setMchId("mocker");
        mockResult.setMchOrderNo("MockOrder" + System.currentTimeMillis());
        return mockResult;
    }

    public PaymentPayNotifyValidateResultVO validatePayNotify(String configurationJson, String notifyData) {
        PaymentPayNotifyValidateResultVO mockResult = new PaymentPayNotifyValidateResultVO();
        mockResult.setTradeNO("MockPay" + System.currentTimeMillis());
        mockResult.setIsPaid(Boolean.valueOf(true));
        return mockResult;
    }

    public PaymentRefundNotifyParseResultVO parseRefundNotify(String notifyData) {
        PaymentRefundNotifyParseResultVO mockResult = new PaymentRefundNotifyParseResultVO();
        mockResult.setMchId("mocker");
        mockResult.setMchOrderNo("MockOrder" + System.currentTimeMillis());
        return mockResult;
    }

    public PaymentRefundNotifyValidateResultVO validateRefundNotify(String configurationJson, String notifyData) {
        PaymentRefundNotifyValidateResultVO mockResult = new PaymentRefundNotifyValidateResultVO();
        mockResult.setMchRefundNO("MockOutRefundNo" + System.currentTimeMillis());
        mockResult.setTradeNO("MockPay" + System.currentTimeMillis());
        mockResult.setIsRefund(Boolean.valueOf(true));
        return mockResult;
    }
}

