/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.component.service.payment.service;

import com.ec.primus.commons.exception.ExceptionType;
import com.ec.primus.commons.utils.AssertUtils;
import com.ec.primus.commons.vo.PageResultVO;
import com.ec.primus.component.model.payment.enums.MerchantExceptionEnum;
import com.ec.primus.component.model.payment.enums.PaymentExceptionEnum;
import com.ec.primus.component.model.payment.vo.merchant.MerchantCreateReqVO;
import com.ec.primus.component.model.payment.vo.merchant.MerchantDisableReqVO;
import com.ec.primus.component.model.payment.vo.merchant.MerchantFindAllReqVO;
import com.ec.primus.component.model.payment.vo.merchant.MerchantUpdateReqVO;
import com.ec.primus.component.model.payment.vo.merchant.MerchantVO;
import com.ec.primus.component.service.base.service.AbstractComponentService;
import com.ec.primus.component.service.payment.dao.po.Merchant;
import com.ec.primus.component.service.payment.dao.repository.MerchantRepository;
import com.ec.primus.component.service.payment.dao.specification.PaymentChannelQueryVoToSpecification;
import com.ec.primus.component.service.payment.transfer.MerchantCreateReqVOToMerchant;
import com.ec.primus.component.service.payment.transfer.MerchantToMerchantVO;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MerchantService
extends AbstractComponentService {
    private final MerchantRepository merchantRepository;

    @Autowired
    public MerchantService(MerchantRepository merchantRepository) {
        this.merchantRepository = merchantRepository;
    }

    @PostConstruct
    public void setup() {
        if (this.findOne("DEFAULT_MERCHANT") == null) {
            Merchant defaultMerchant = new Merchant();
            defaultMerchant.setId("DEFAULT_MERCHANT");
            defaultMerchant.setName("\u9ed8\u8ba4\u5546\u6237");
            defaultMerchant.setRemark("\u7cfb\u7edf\u521d\u59cb\u5316\u7684\u65f6\u5019\u9ed8\u8ba4\u7684\u5546\u6237");
            this.merchantRepository.save(defaultMerchant);
        }
    }

    public MerchantVO create(MerchantCreateReqVO reqVO) {
        Merchant newMerchant = new MerchantCreateReqVOToMerchant().apply(reqVO);
        newMerchant.setId(this.nextId().toString());
        Merchant savedMerchant = (Merchant)this.merchantRepository.save(newMerchant);
        return new MerchantToMerchantVO().apply(savedMerchant);
    }

    public MerchantVO get(String id) {
        Merchant merchant = this.findOne(id);
        return new MerchantToMerchantVO().apply(merchant);
    }

    Merchant findOne(String mchId) {
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)mchId), (ExceptionType)MerchantExceptionEnum.MERCHANT_NOT_FOUND, (String)"Merchant id is null");
        return this.merchantRepository.findByIdAndDeleteFlag(mchId, false);
    }

    public PageResultVO<MerchantVO> findAll(MerchantFindAllReqVO reqVO) {
        AssertUtils.notNull((Object)reqVO, (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument reqVO is null");
        PageRequest pageRequest = reqVO.toPageRequest();
        Page merchantPage = this.merchantRepository.findAll((Specification)new PaymentChannelQueryVoToSpecification(reqVO), (Pageable)pageRequest);
        return PageResultVO.ofPages((Page)merchantPage, (Function)new MerchantToMerchantVO());
    }

    public MerchantVO update(MerchantUpdateReqVO reqVO) {
        Merchant merchant = this.findOne(reqVO.getId());
        BeanUtils.copyProperties((Object)reqVO, (Object)merchant);
        Merchant savedMerchant = (Merchant)this.merchantRepository.save(merchant);
        return new MerchantToMerchantVO().apply(savedMerchant);
    }

    @Transactional(rollbackFor={Exception.class})
    public void disable(MerchantDisableReqVO reqVO) {
        AssertUtils.notNull((Object)reqVO, (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument reqVO is null");
        AssertUtils.notNull((Object)reqVO.getId(), (ExceptionType)PaymentExceptionEnum.ILLEGAL_PARAMETER, (String)"Argument reqVO.id is null");
        this.merchantRepository.disable(reqVO.getId());
    }
}

